/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomerSegmentsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.ListCustomerSegmentsResponse;
import com.squareup.square.models.RetrieveCustomerSegmentResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCustomerSegmentsApi
extends BaseApi
implements CustomerSegmentsApi {
    public DefaultCustomerSegmentsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListCustomerSegmentsResponse listCustomerSegments(String cursor, Integer limit) throws ApiException, IOException {
        return (ListCustomerSegmentsResponse)this.prepareListCustomerSegmentsRequest(cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListCustomerSegmentsResponse> listCustomerSegmentsAsync(String cursor, Integer limit) {
        try {
            return this.prepareListCustomerSegmentsRequest(cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCustomerSegmentsResponse, ApiException> prepareListCustomerSegmentsRequest(String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/segments").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCustomerSegmentsResponse)ApiHelper.deserialize((String)response, ListCustomerSegmentsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCustomerSegmentResponse retrieveCustomerSegment(String segmentId) throws ApiException, IOException {
        return (RetrieveCustomerSegmentResponse)this.prepareRetrieveCustomerSegmentRequest(segmentId).execute();
    }

    @Override
    public CompletableFuture<RetrieveCustomerSegmentResponse> retrieveCustomerSegmentAsync(String segmentId) {
        try {
            return this.prepareRetrieveCustomerSegmentRequest(segmentId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCustomerSegmentResponse, ApiException> prepareRetrieveCustomerSegmentRequest(String segmentId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/segments/{segment_id}").templateParam(param -> param.key("segment_id").value((Object)segmentId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCustomerSegmentResponse)ApiHelper.deserialize((String)response, RetrieveCustomerSegmentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

