/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomersApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.AddGroupToCustomerResponse;
import com.squareup.square.models.CreateCustomerCardRequest;
import com.squareup.square.models.CreateCustomerCardResponse;
import com.squareup.square.models.CreateCustomerRequest;
import com.squareup.square.models.CreateCustomerResponse;
import com.squareup.square.models.DeleteCustomerCardResponse;
import com.squareup.square.models.DeleteCustomerResponse;
import com.squareup.square.models.ListCustomersResponse;
import com.squareup.square.models.RemoveGroupFromCustomerResponse;
import com.squareup.square.models.RetrieveCustomerResponse;
import com.squareup.square.models.SearchCustomersRequest;
import com.squareup.square.models.SearchCustomersResponse;
import com.squareup.square.models.UpdateCustomerRequest;
import com.squareup.square.models.UpdateCustomerResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCustomersApi
extends BaseApi
implements CustomersApi {
    public DefaultCustomersApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListCustomersResponse listCustomers(String cursor, Integer limit, String sortField, String sortOrder, Boolean count) throws ApiException, IOException {
        return (ListCustomersResponse)this.prepareListCustomersRequest(cursor, limit, sortField, sortOrder, count).execute();
    }

    @Override
    public CompletableFuture<ListCustomersResponse> listCustomersAsync(String cursor, Integer limit, String sortField, String sortOrder, Boolean count) {
        try {
            return this.prepareListCustomersRequest(cursor, limit, sortField, sortOrder, count).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCustomersResponse, ApiException> prepareListCustomersRequest(String cursor, Integer limit, String sortField, String sortOrder, Boolean count) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("sort_field").value((Object)sortField).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("count").value((Object)(count != null ? count : false)).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCustomersResponse)ApiHelper.deserialize((String)response, ListCustomersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateCustomerResponse createCustomer(CreateCustomerRequest body) throws ApiException, IOException {
        return (CreateCustomerResponse)this.prepareCreateCustomerRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateCustomerResponse> createCustomerAsync(CreateCustomerRequest body) {
        try {
            return this.prepareCreateCustomerRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateCustomerResponse, ApiException> prepareCreateCustomerRequest(CreateCustomerRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateCustomerResponse)ApiHelper.deserialize((String)response, CreateCustomerResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchCustomersResponse searchCustomers(SearchCustomersRequest body) throws ApiException, IOException {
        return (SearchCustomersResponse)this.prepareSearchCustomersRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchCustomersResponse> searchCustomersAsync(SearchCustomersRequest body) {
        try {
            return this.prepareSearchCustomersRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchCustomersResponse, ApiException> prepareSearchCustomersRequest(SearchCustomersRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchCustomersResponse)ApiHelper.deserialize((String)response, SearchCustomersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteCustomerResponse deleteCustomer(String customerId, Long version) throws ApiException, IOException {
        return (DeleteCustomerResponse)this.prepareDeleteCustomerRequest(customerId, version).execute();
    }

    @Override
    public CompletableFuture<DeleteCustomerResponse> deleteCustomerAsync(String customerId, Long version) {
        try {
            return this.prepareDeleteCustomerRequest(customerId, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteCustomerResponse, ApiException> prepareDeleteCustomerRequest(String customerId, Long version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteCustomerResponse)ApiHelper.deserialize((String)response, DeleteCustomerResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCustomerResponse retrieveCustomer(String customerId) throws ApiException, IOException {
        return (RetrieveCustomerResponse)this.prepareRetrieveCustomerRequest(customerId).execute();
    }

    @Override
    public CompletableFuture<RetrieveCustomerResponse> retrieveCustomerAsync(String customerId) {
        try {
            return this.prepareRetrieveCustomerRequest(customerId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCustomerResponse, ApiException> prepareRetrieveCustomerRequest(String customerId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}").templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCustomerResponse)ApiHelper.deserialize((String)response, RetrieveCustomerResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateCustomerResponse updateCustomer(String customerId, UpdateCustomerRequest body) throws ApiException, IOException {
        return (UpdateCustomerResponse)this.prepareUpdateCustomerRequest(customerId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateCustomerResponse> updateCustomerAsync(String customerId, UpdateCustomerRequest body) {
        try {
            return this.prepareUpdateCustomerRequest(customerId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateCustomerResponse, ApiException> prepareUpdateCustomerRequest(String customerId, UpdateCustomerRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateCustomerResponse)ApiHelper.deserialize((String)response, UpdateCustomerResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    @Deprecated
    public CreateCustomerCardResponse createCustomerCard(String customerId, CreateCustomerCardRequest body) throws ApiException, IOException {
        return (CreateCustomerCardResponse)this.prepareCreateCustomerCardRequest(customerId, body).execute();
    }

    @Override
    @Deprecated
    public CompletableFuture<CreateCustomerCardResponse> createCustomerCardAsync(String customerId, CreateCustomerCardRequest body) {
        try {
            return this.prepareCreateCustomerCardRequest(customerId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateCustomerCardResponse, ApiException> prepareCreateCustomerCardRequest(String customerId, CreateCustomerCardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/cards").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateCustomerCardResponse)ApiHelper.deserialize((String)response, CreateCustomerCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    @Deprecated
    public DeleteCustomerCardResponse deleteCustomerCard(String customerId, String cardId) throws ApiException, IOException {
        return (DeleteCustomerCardResponse)this.prepareDeleteCustomerCardRequest(customerId, cardId).execute();
    }

    @Override
    @Deprecated
    public CompletableFuture<DeleteCustomerCardResponse> deleteCustomerCardAsync(String customerId, String cardId) {
        try {
            return this.prepareDeleteCustomerCardRequest(customerId, cardId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteCustomerCardResponse, ApiException> prepareDeleteCustomerCardRequest(String customerId, String cardId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/cards/{card_id}").templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).templateParam(param -> param.key("card_id").value((Object)cardId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteCustomerCardResponse)ApiHelper.deserialize((String)response, DeleteCustomerCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RemoveGroupFromCustomerResponse removeGroupFromCustomer(String customerId, String groupId) throws ApiException, IOException {
        return (RemoveGroupFromCustomerResponse)this.prepareRemoveGroupFromCustomerRequest(customerId, groupId).execute();
    }

    @Override
    public CompletableFuture<RemoveGroupFromCustomerResponse> removeGroupFromCustomerAsync(String customerId, String groupId) {
        try {
            return this.prepareRemoveGroupFromCustomerRequest(customerId, groupId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RemoveGroupFromCustomerResponse, ApiException> prepareRemoveGroupFromCustomerRequest(String customerId, String groupId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/groups/{group_id}").templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).templateParam(param -> param.key("group_id").value((Object)groupId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RemoveGroupFromCustomerResponse)ApiHelper.deserialize((String)response, RemoveGroupFromCustomerResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public AddGroupToCustomerResponse addGroupToCustomer(String customerId, String groupId) throws ApiException, IOException {
        return (AddGroupToCustomerResponse)this.prepareAddGroupToCustomerRequest(customerId, groupId).execute();
    }

    @Override
    public CompletableFuture<AddGroupToCustomerResponse> addGroupToCustomerAsync(String customerId, String groupId) {
        try {
            return this.prepareAddGroupToCustomerRequest(customerId, groupId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<AddGroupToCustomerResponse, ApiException> prepareAddGroupToCustomerRequest(String customerId, String groupId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/groups/{group_id}").templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).templateParam(param -> param.key("group_id").value((Object)groupId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (AddGroupToCustomerResponse)ApiHelper.deserialize((String)response, AddGroupToCustomerResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

