/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.DevicesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateDeviceCodeRequest;
import com.squareup.square.models.CreateDeviceCodeResponse;
import com.squareup.square.models.GetDeviceCodeResponse;
import com.squareup.square.models.GetDeviceResponse;
import com.squareup.square.models.ListDeviceCodesResponse;
import com.squareup.square.models.ListDevicesResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultDevicesApi
extends BaseApi
implements DevicesApi {
    public DefaultDevicesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListDevicesResponse listDevices(String cursor, String sortOrder, Integer limit, String locationId) throws ApiException, IOException {
        return (ListDevicesResponse)this.prepareListDevicesRequest(cursor, sortOrder, limit, locationId).execute();
    }

    @Override
    public CompletableFuture<ListDevicesResponse> listDevicesAsync(String cursor, String sortOrder, Integer limit, String locationId) {
        try {
            return this.prepareListDevicesRequest(cursor, sortOrder, limit, locationId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListDevicesResponse, ApiException> prepareListDevicesRequest(String cursor, String sortOrder, Integer limit, String locationId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/devices").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListDevicesResponse)ApiHelper.deserialize((String)response, ListDevicesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListDeviceCodesResponse listDeviceCodes(String cursor, String locationId, String productType, String status) throws ApiException, IOException {
        return (ListDeviceCodesResponse)this.prepareListDeviceCodesRequest(cursor, locationId, productType, status).execute();
    }

    @Override
    public CompletableFuture<ListDeviceCodesResponse> listDeviceCodesAsync(String cursor, String locationId, String productType, String status) {
        try {
            return this.prepareListDeviceCodesRequest(cursor, locationId, productType, status).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListDeviceCodesResponse, ApiException> prepareListDeviceCodesRequest(String cursor, String locationId, String productType, String status) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/devices/codes").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("product_type").value((Object)productType).isRequired(false)).queryParam(param -> param.key("status").value((Object)status).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListDeviceCodesResponse)ApiHelper.deserialize((String)response, ListDeviceCodesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateDeviceCodeResponse createDeviceCode(CreateDeviceCodeRequest body) throws ApiException, IOException {
        return (CreateDeviceCodeResponse)this.prepareCreateDeviceCodeRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateDeviceCodeResponse> createDeviceCodeAsync(CreateDeviceCodeRequest body) {
        try {
            return this.prepareCreateDeviceCodeRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateDeviceCodeResponse, ApiException> prepareCreateDeviceCodeRequest(CreateDeviceCodeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/devices/codes").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateDeviceCodeResponse)ApiHelper.deserialize((String)response, CreateDeviceCodeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetDeviceCodeResponse getDeviceCode(String id) throws ApiException, IOException {
        return (GetDeviceCodeResponse)this.prepareGetDeviceCodeRequest(id).execute();
    }

    @Override
    public CompletableFuture<GetDeviceCodeResponse> getDeviceCodeAsync(String id) {
        try {
            return this.prepareGetDeviceCodeRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetDeviceCodeResponse, ApiException> prepareGetDeviceCodeRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/devices/codes/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetDeviceCodeResponse)ApiHelper.deserialize((String)response, GetDeviceCodeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetDeviceResponse getDevice(String deviceId) throws ApiException, IOException {
        return (GetDeviceResponse)this.prepareGetDeviceRequest(deviceId).execute();
    }

    @Override
    public CompletableFuture<GetDeviceResponse> getDeviceAsync(String deviceId) {
        try {
            return this.prepareGetDeviceRequest(deviceId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetDeviceResponse, ApiException> prepareGetDeviceRequest(String deviceId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/devices/{device_id}").templateParam(param -> param.key("device_id").value((Object)deviceId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetDeviceResponse)ApiHelper.deserialize((String)response, GetDeviceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

