/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.DisputesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.AcceptDisputeResponse;
import com.squareup.square.models.CreateDisputeEvidenceFileRequest;
import com.squareup.square.models.CreateDisputeEvidenceFileResponse;
import com.squareup.square.models.CreateDisputeEvidenceTextRequest;
import com.squareup.square.models.CreateDisputeEvidenceTextResponse;
import com.squareup.square.models.DeleteDisputeEvidenceResponse;
import com.squareup.square.models.ListDisputeEvidenceResponse;
import com.squareup.square.models.ListDisputesResponse;
import com.squareup.square.models.RetrieveDisputeEvidenceResponse;
import com.squareup.square.models.RetrieveDisputeResponse;
import com.squareup.square.models.SubmitEvidenceResponse;
import com.squareup.square.utilities.FileWrapper;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.MutliPartRequestType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultDisputesApi
extends BaseApi
implements DisputesApi {
    public DefaultDisputesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListDisputesResponse listDisputes(String cursor, String states, String locationId) throws ApiException, IOException {
        return (ListDisputesResponse)this.prepareListDisputesRequest(cursor, states, locationId).execute();
    }

    @Override
    public CompletableFuture<ListDisputesResponse> listDisputesAsync(String cursor, String states, String locationId) {
        try {
            return this.prepareListDisputesRequest(cursor, states, locationId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListDisputesResponse, ApiException> prepareListDisputesRequest(String cursor, String states, String locationId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("states").value((Object)states).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListDisputesResponse)ApiHelper.deserialize((String)response, ListDisputesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveDisputeResponse retrieveDispute(String disputeId) throws ApiException, IOException {
        return (RetrieveDisputeResponse)this.prepareRetrieveDisputeRequest(disputeId).execute();
    }

    @Override
    public CompletableFuture<RetrieveDisputeResponse> retrieveDisputeAsync(String disputeId) {
        try {
            return this.prepareRetrieveDisputeRequest(disputeId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveDisputeResponse, ApiException> prepareRetrieveDisputeRequest(String disputeId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}").templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveDisputeResponse)ApiHelper.deserialize((String)response, RetrieveDisputeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public AcceptDisputeResponse acceptDispute(String disputeId) throws ApiException, IOException {
        return (AcceptDisputeResponse)this.prepareAcceptDisputeRequest(disputeId).execute();
    }

    @Override
    public CompletableFuture<AcceptDisputeResponse> acceptDisputeAsync(String disputeId) {
        try {
            return this.prepareAcceptDisputeRequest(disputeId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<AcceptDisputeResponse, ApiException> prepareAcceptDisputeRequest(String disputeId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/accept").templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (AcceptDisputeResponse)ApiHelper.deserialize((String)response, AcceptDisputeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListDisputeEvidenceResponse listDisputeEvidence(String disputeId, String cursor) throws ApiException, IOException {
        return (ListDisputeEvidenceResponse)this.prepareListDisputeEvidenceRequest(disputeId, cursor).execute();
    }

    @Override
    public CompletableFuture<ListDisputeEvidenceResponse> listDisputeEvidenceAsync(String disputeId, String cursor) {
        try {
            return this.prepareListDisputeEvidenceRequest(disputeId, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListDisputeEvidenceResponse, ApiException> prepareListDisputeEvidenceRequest(String disputeId, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/evidence").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListDisputeEvidenceResponse)ApiHelper.deserialize((String)response, ListDisputeEvidenceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateDisputeEvidenceFileResponse createDisputeEvidenceFile(String disputeId, CreateDisputeEvidenceFileRequest request, FileWrapper imageFile) throws ApiException, IOException {
        return (CreateDisputeEvidenceFileResponse)this.prepareCreateDisputeEvidenceFileRequest(disputeId, request, imageFile).execute();
    }

    @Override
    public CompletableFuture<CreateDisputeEvidenceFileResponse> createDisputeEvidenceFileAsync(String disputeId, CreateDisputeEvidenceFileRequest request, FileWrapper imageFile) {
        try {
            return this.prepareCreateDisputeEvidenceFileRequest(disputeId, request, imageFile).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateDisputeEvidenceFileResponse, ApiException> prepareCreateDisputeEvidenceFileRequest(String disputeId, CreateDisputeEvidenceFileRequest request, FileWrapper imageFile) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/evidence-files").formParam(param -> param.key("request").value((Object)request).multipartSerializer(() -> ApiHelper.serialize((Object)request)).multiPartRequestType(MutliPartRequestType.MULTI_PART).multipartHeaders("Content-Type", "application/json; charset=utf-8")).formParam(param -> param.key("image_file").value((Object)imageFile).multiPartRequestType(MutliPartRequestType.MULTI_PART_FILE).multipartHeaders("Content-Type", "image/jpeg")).templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateDisputeEvidenceFileResponse)ApiHelper.deserialize((String)response, CreateDisputeEvidenceFileResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateDisputeEvidenceTextResponse createDisputeEvidenceText(String disputeId, CreateDisputeEvidenceTextRequest body) throws ApiException, IOException {
        return (CreateDisputeEvidenceTextResponse)this.prepareCreateDisputeEvidenceTextRequest(disputeId, body).execute();
    }

    @Override
    public CompletableFuture<CreateDisputeEvidenceTextResponse> createDisputeEvidenceTextAsync(String disputeId, CreateDisputeEvidenceTextRequest body) {
        try {
            return this.prepareCreateDisputeEvidenceTextRequest(disputeId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateDisputeEvidenceTextResponse, ApiException> prepareCreateDisputeEvidenceTextRequest(String disputeId, CreateDisputeEvidenceTextRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/evidence-text").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateDisputeEvidenceTextResponse)ApiHelper.deserialize((String)response, CreateDisputeEvidenceTextResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteDisputeEvidenceResponse deleteDisputeEvidence(String disputeId, String evidenceId) throws ApiException, IOException {
        return (DeleteDisputeEvidenceResponse)this.prepareDeleteDisputeEvidenceRequest(disputeId, evidenceId).execute();
    }

    @Override
    public CompletableFuture<DeleteDisputeEvidenceResponse> deleteDisputeEvidenceAsync(String disputeId, String evidenceId) {
        try {
            return this.prepareDeleteDisputeEvidenceRequest(disputeId, evidenceId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteDisputeEvidenceResponse, ApiException> prepareDeleteDisputeEvidenceRequest(String disputeId, String evidenceId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/evidence/{evidence_id}").templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).templateParam(param -> param.key("evidence_id").value((Object)evidenceId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteDisputeEvidenceResponse)ApiHelper.deserialize((String)response, DeleteDisputeEvidenceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveDisputeEvidenceResponse retrieveDisputeEvidence(String disputeId, String evidenceId) throws ApiException, IOException {
        return (RetrieveDisputeEvidenceResponse)this.prepareRetrieveDisputeEvidenceRequest(disputeId, evidenceId).execute();
    }

    @Override
    public CompletableFuture<RetrieveDisputeEvidenceResponse> retrieveDisputeEvidenceAsync(String disputeId, String evidenceId) {
        try {
            return this.prepareRetrieveDisputeEvidenceRequest(disputeId, evidenceId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveDisputeEvidenceResponse, ApiException> prepareRetrieveDisputeEvidenceRequest(String disputeId, String evidenceId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/evidence/{evidence_id}").templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).templateParam(param -> param.key("evidence_id").value((Object)evidenceId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveDisputeEvidenceResponse)ApiHelper.deserialize((String)response, RetrieveDisputeEvidenceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SubmitEvidenceResponse submitEvidence(String disputeId) throws ApiException, IOException {
        return (SubmitEvidenceResponse)this.prepareSubmitEvidenceRequest(disputeId).execute();
    }

    @Override
    public CompletableFuture<SubmitEvidenceResponse> submitEvidenceAsync(String disputeId) {
        try {
            return this.prepareSubmitEvidenceRequest(disputeId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SubmitEvidenceResponse, ApiException> prepareSubmitEvidenceRequest(String disputeId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/disputes/{dispute_id}/submit-evidence").templateParam(param -> param.key("dispute_id").value((Object)disputeId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SubmitEvidenceResponse)ApiHelper.deserialize((String)response, SubmitEvidenceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

