/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.GiftCardsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateGiftCardRequest;
import com.squareup.square.models.CreateGiftCardResponse;
import com.squareup.square.models.LinkCustomerToGiftCardRequest;
import com.squareup.square.models.LinkCustomerToGiftCardResponse;
import com.squareup.square.models.ListGiftCardsResponse;
import com.squareup.square.models.RetrieveGiftCardFromGANRequest;
import com.squareup.square.models.RetrieveGiftCardFromGANResponse;
import com.squareup.square.models.RetrieveGiftCardFromNonceRequest;
import com.squareup.square.models.RetrieveGiftCardFromNonceResponse;
import com.squareup.square.models.RetrieveGiftCardResponse;
import com.squareup.square.models.UnlinkCustomerFromGiftCardRequest;
import com.squareup.square.models.UnlinkCustomerFromGiftCardResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultGiftCardsApi
extends BaseApi
implements GiftCardsApi {
    public DefaultGiftCardsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListGiftCardsResponse listGiftCards(String type, String state, Integer limit, String cursor, String customerId) throws ApiException, IOException {
        return (ListGiftCardsResponse)this.prepareListGiftCardsRequest(type, state, limit, cursor, customerId).execute();
    }

    @Override
    public CompletableFuture<ListGiftCardsResponse> listGiftCardsAsync(String type, String state, Integer limit, String cursor, String customerId) {
        try {
            return this.prepareListGiftCardsRequest(type, state, limit, cursor, customerId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListGiftCardsResponse, ApiException> prepareListGiftCardsRequest(String type, String state, Integer limit, String cursor, String customerId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards").queryParam(param -> param.key("type").value((Object)type).isRequired(false)).queryParam(param -> param.key("state").value((Object)state).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("customer_id").value((Object)customerId).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListGiftCardsResponse)ApiHelper.deserialize((String)response, ListGiftCardsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateGiftCardResponse createGiftCard(CreateGiftCardRequest body) throws ApiException, IOException {
        return (CreateGiftCardResponse)this.prepareCreateGiftCardRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateGiftCardResponse> createGiftCardAsync(CreateGiftCardRequest body) {
        try {
            return this.prepareCreateGiftCardRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateGiftCardResponse, ApiException> prepareCreateGiftCardRequest(CreateGiftCardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateGiftCardResponse)ApiHelper.deserialize((String)response, CreateGiftCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveGiftCardFromGANResponse retrieveGiftCardFromGAN(RetrieveGiftCardFromGANRequest body) throws ApiException, IOException {
        return (RetrieveGiftCardFromGANResponse)this.prepareRetrieveGiftCardFromGANRequest(body).execute();
    }

    @Override
    public CompletableFuture<RetrieveGiftCardFromGANResponse> retrieveGiftCardFromGANAsync(RetrieveGiftCardFromGANRequest body) {
        try {
            return this.prepareRetrieveGiftCardFromGANRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveGiftCardFromGANResponse, ApiException> prepareRetrieveGiftCardFromGANRequest(RetrieveGiftCardFromGANRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/from-gan").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveGiftCardFromGANResponse)ApiHelper.deserialize((String)response, RetrieveGiftCardFromGANResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveGiftCardFromNonceResponse retrieveGiftCardFromNonce(RetrieveGiftCardFromNonceRequest body) throws ApiException, IOException {
        return (RetrieveGiftCardFromNonceResponse)this.prepareRetrieveGiftCardFromNonceRequest(body).execute();
    }

    @Override
    public CompletableFuture<RetrieveGiftCardFromNonceResponse> retrieveGiftCardFromNonceAsync(RetrieveGiftCardFromNonceRequest body) {
        try {
            return this.prepareRetrieveGiftCardFromNonceRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveGiftCardFromNonceResponse, ApiException> prepareRetrieveGiftCardFromNonceRequest(RetrieveGiftCardFromNonceRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/from-nonce").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveGiftCardFromNonceResponse)ApiHelper.deserialize((String)response, RetrieveGiftCardFromNonceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public LinkCustomerToGiftCardResponse linkCustomerToGiftCard(String giftCardId, LinkCustomerToGiftCardRequest body) throws ApiException, IOException {
        return (LinkCustomerToGiftCardResponse)this.prepareLinkCustomerToGiftCardRequest(giftCardId, body).execute();
    }

    @Override
    public CompletableFuture<LinkCustomerToGiftCardResponse> linkCustomerToGiftCardAsync(String giftCardId, LinkCustomerToGiftCardRequest body) {
        try {
            return this.prepareLinkCustomerToGiftCardRequest(giftCardId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<LinkCustomerToGiftCardResponse, ApiException> prepareLinkCustomerToGiftCardRequest(String giftCardId, LinkCustomerToGiftCardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/{gift_card_id}/link-customer").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("gift_card_id").value((Object)giftCardId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (LinkCustomerToGiftCardResponse)ApiHelper.deserialize((String)response, LinkCustomerToGiftCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UnlinkCustomerFromGiftCardResponse unlinkCustomerFromGiftCard(String giftCardId, UnlinkCustomerFromGiftCardRequest body) throws ApiException, IOException {
        return (UnlinkCustomerFromGiftCardResponse)this.prepareUnlinkCustomerFromGiftCardRequest(giftCardId, body).execute();
    }

    @Override
    public CompletableFuture<UnlinkCustomerFromGiftCardResponse> unlinkCustomerFromGiftCardAsync(String giftCardId, UnlinkCustomerFromGiftCardRequest body) {
        try {
            return this.prepareUnlinkCustomerFromGiftCardRequest(giftCardId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UnlinkCustomerFromGiftCardResponse, ApiException> prepareUnlinkCustomerFromGiftCardRequest(String giftCardId, UnlinkCustomerFromGiftCardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/{gift_card_id}/unlink-customer").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("gift_card_id").value((Object)giftCardId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UnlinkCustomerFromGiftCardResponse)ApiHelper.deserialize((String)response, UnlinkCustomerFromGiftCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveGiftCardResponse retrieveGiftCard(String id) throws ApiException, IOException {
        return (RetrieveGiftCardResponse)this.prepareRetrieveGiftCardRequest(id).execute();
    }

    @Override
    public CompletableFuture<RetrieveGiftCardResponse> retrieveGiftCardAsync(String id) {
        try {
            return this.prepareRetrieveGiftCardRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveGiftCardResponse, ApiException> prepareRetrieveGiftCardRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveGiftCardResponse)ApiHelper.deserialize((String)response, RetrieveGiftCardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

