/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.InvoicesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CancelInvoiceRequest;
import com.squareup.square.models.CancelInvoiceResponse;
import com.squareup.square.models.CreateInvoiceAttachmentRequest;
import com.squareup.square.models.CreateInvoiceAttachmentResponse;
import com.squareup.square.models.CreateInvoiceRequest;
import com.squareup.square.models.CreateInvoiceResponse;
import com.squareup.square.models.DeleteInvoiceAttachmentResponse;
import com.squareup.square.models.DeleteInvoiceResponse;
import com.squareup.square.models.GetInvoiceResponse;
import com.squareup.square.models.ListInvoicesResponse;
import com.squareup.square.models.PublishInvoiceRequest;
import com.squareup.square.models.PublishInvoiceResponse;
import com.squareup.square.models.SearchInvoicesRequest;
import com.squareup.square.models.SearchInvoicesResponse;
import com.squareup.square.models.UpdateInvoiceRequest;
import com.squareup.square.models.UpdateInvoiceResponse;
import com.squareup.square.utilities.FileWrapper;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.MutliPartRequestType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultInvoicesApi
extends BaseApi
implements InvoicesApi {
    public DefaultInvoicesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListInvoicesResponse listInvoices(String locationId, String cursor, Integer limit) throws ApiException, IOException {
        return (ListInvoicesResponse)this.prepareListInvoicesRequest(locationId, cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListInvoicesResponse> listInvoicesAsync(String locationId, String cursor, Integer limit) {
        try {
            return this.prepareListInvoicesRequest(locationId, cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListInvoicesResponse, ApiException> prepareListInvoicesRequest(String locationId, String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices").queryParam(param -> param.key("location_id").value((Object)locationId)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListInvoicesResponse)ApiHelper.deserialize((String)response, ListInvoicesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateInvoiceResponse createInvoice(CreateInvoiceRequest body) throws ApiException, IOException {
        return (CreateInvoiceResponse)this.prepareCreateInvoiceRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateInvoiceResponse> createInvoiceAsync(CreateInvoiceRequest body) {
        try {
            return this.prepareCreateInvoiceRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateInvoiceResponse, ApiException> prepareCreateInvoiceRequest(CreateInvoiceRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateInvoiceResponse)ApiHelper.deserialize((String)response, CreateInvoiceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchInvoicesResponse searchInvoices(SearchInvoicesRequest body) throws ApiException, IOException {
        return (SearchInvoicesResponse)this.prepareSearchInvoicesRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchInvoicesResponse> searchInvoicesAsync(SearchInvoicesRequest body) {
        try {
            return this.prepareSearchInvoicesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchInvoicesResponse, ApiException> prepareSearchInvoicesRequest(SearchInvoicesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchInvoicesResponse)ApiHelper.deserialize((String)response, SearchInvoicesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteInvoiceResponse deleteInvoice(String invoiceId, Integer version) throws ApiException, IOException {
        return (DeleteInvoiceResponse)this.prepareDeleteInvoiceRequest(invoiceId, version).execute();
    }

    @Override
    public CompletableFuture<DeleteInvoiceResponse> deleteInvoiceAsync(String invoiceId, Integer version) {
        try {
            return this.prepareDeleteInvoiceRequest(invoiceId, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteInvoiceResponse, ApiException> prepareDeleteInvoiceRequest(String invoiceId, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteInvoiceResponse)ApiHelper.deserialize((String)response, DeleteInvoiceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetInvoiceResponse getInvoice(String invoiceId) throws ApiException, IOException {
        return (GetInvoiceResponse)this.prepareGetInvoiceRequest(invoiceId).execute();
    }

    @Override
    public CompletableFuture<GetInvoiceResponse> getInvoiceAsync(String invoiceId) {
        try {
            return this.prepareGetInvoiceRequest(invoiceId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetInvoiceResponse, ApiException> prepareGetInvoiceRequest(String invoiceId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}").templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetInvoiceResponse)ApiHelper.deserialize((String)response, GetInvoiceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateInvoiceResponse updateInvoice(String invoiceId, UpdateInvoiceRequest body) throws ApiException, IOException {
        return (UpdateInvoiceResponse)this.prepareUpdateInvoiceRequest(invoiceId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateInvoiceResponse> updateInvoiceAsync(String invoiceId, UpdateInvoiceRequest body) {
        try {
            return this.prepareUpdateInvoiceRequest(invoiceId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateInvoiceResponse, ApiException> prepareUpdateInvoiceRequest(String invoiceId, UpdateInvoiceRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateInvoiceResponse)ApiHelper.deserialize((String)response, UpdateInvoiceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateInvoiceAttachmentResponse createInvoiceAttachment(String invoiceId, CreateInvoiceAttachmentRequest request, FileWrapper imageFile) throws ApiException, IOException {
        return (CreateInvoiceAttachmentResponse)this.prepareCreateInvoiceAttachmentRequest(invoiceId, request, imageFile).execute();
    }

    @Override
    public CompletableFuture<CreateInvoiceAttachmentResponse> createInvoiceAttachmentAsync(String invoiceId, CreateInvoiceAttachmentRequest request, FileWrapper imageFile) {
        try {
            return this.prepareCreateInvoiceAttachmentRequest(invoiceId, request, imageFile).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateInvoiceAttachmentResponse, ApiException> prepareCreateInvoiceAttachmentRequest(String invoiceId, CreateInvoiceAttachmentRequest request, FileWrapper imageFile) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}/attachments").formParam(param -> param.key("request").value((Object)request).multipartSerializer(() -> ApiHelper.serialize((Object)request)).multiPartRequestType(MutliPartRequestType.MULTI_PART).multipartHeaders("Content-Type", "application/json; charset=utf-8")).formParam(param -> param.key("image_file").value((Object)imageFile).multiPartRequestType(MutliPartRequestType.MULTI_PART_FILE).multipartHeaders("Content-Type", "image/jpeg")).templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateInvoiceAttachmentResponse)ApiHelper.deserialize((String)response, CreateInvoiceAttachmentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteInvoiceAttachmentResponse deleteInvoiceAttachment(String invoiceId, String attachmentId) throws ApiException, IOException {
        return (DeleteInvoiceAttachmentResponse)this.prepareDeleteInvoiceAttachmentRequest(invoiceId, attachmentId).execute();
    }

    @Override
    public CompletableFuture<DeleteInvoiceAttachmentResponse> deleteInvoiceAttachmentAsync(String invoiceId, String attachmentId) {
        try {
            return this.prepareDeleteInvoiceAttachmentRequest(invoiceId, attachmentId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteInvoiceAttachmentResponse, ApiException> prepareDeleteInvoiceAttachmentRequest(String invoiceId, String attachmentId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}/attachments/{attachment_id}").templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).templateParam(param -> param.key("attachment_id").value((Object)attachmentId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteInvoiceAttachmentResponse)ApiHelper.deserialize((String)response, DeleteInvoiceAttachmentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelInvoiceResponse cancelInvoice(String invoiceId, CancelInvoiceRequest body) throws ApiException, IOException {
        return (CancelInvoiceResponse)this.prepareCancelInvoiceRequest(invoiceId, body).execute();
    }

    @Override
    public CompletableFuture<CancelInvoiceResponse> cancelInvoiceAsync(String invoiceId, CancelInvoiceRequest body) {
        try {
            return this.prepareCancelInvoiceRequest(invoiceId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelInvoiceResponse, ApiException> prepareCancelInvoiceRequest(String invoiceId, CancelInvoiceRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}/cancel").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelInvoiceResponse)ApiHelper.deserialize((String)response, CancelInvoiceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public PublishInvoiceResponse publishInvoice(String invoiceId, PublishInvoiceRequest body) throws ApiException, IOException {
        return (PublishInvoiceResponse)this.preparePublishInvoiceRequest(invoiceId, body).execute();
    }

    @Override
    public CompletableFuture<PublishInvoiceResponse> publishInvoiceAsync(String invoiceId, PublishInvoiceRequest body) {
        try {
            return this.preparePublishInvoiceRequest(invoiceId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<PublishInvoiceResponse, ApiException> preparePublishInvoiceRequest(String invoiceId, PublishInvoiceRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/invoices/{invoice_id}/publish").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("invoice_id").value((Object)invoiceId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (PublishInvoiceResponse)ApiHelper.deserialize((String)response, PublishInvoiceResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

