/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.MerchantCustomAttributesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkDeleteMerchantCustomAttributesRequest;
import com.squareup.square.models.BulkDeleteMerchantCustomAttributesResponse;
import com.squareup.square.models.BulkUpsertMerchantCustomAttributesRequest;
import com.squareup.square.models.BulkUpsertMerchantCustomAttributesResponse;
import com.squareup.square.models.CreateMerchantCustomAttributeDefinitionRequest;
import com.squareup.square.models.CreateMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteMerchantCustomAttributeResponse;
import com.squareup.square.models.ListMerchantCustomAttributeDefinitionsResponse;
import com.squareup.square.models.ListMerchantCustomAttributesResponse;
import com.squareup.square.models.RetrieveMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.models.RetrieveMerchantCustomAttributeResponse;
import com.squareup.square.models.UpdateMerchantCustomAttributeDefinitionRequest;
import com.squareup.square.models.UpdateMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.models.UpsertMerchantCustomAttributeRequest;
import com.squareup.square.models.UpsertMerchantCustomAttributeResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultMerchantCustomAttributesApi
extends BaseApi
implements MerchantCustomAttributesApi {
    public DefaultMerchantCustomAttributesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListMerchantCustomAttributeDefinitionsResponse listMerchantCustomAttributeDefinitions(String visibilityFilter, Integer limit, String cursor) throws ApiException, IOException {
        return (ListMerchantCustomAttributeDefinitionsResponse)this.prepareListMerchantCustomAttributeDefinitionsRequest(visibilityFilter, limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListMerchantCustomAttributeDefinitionsResponse> listMerchantCustomAttributeDefinitionsAsync(String visibilityFilter, Integer limit, String cursor) {
        try {
            return this.prepareListMerchantCustomAttributeDefinitionsRequest(visibilityFilter, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListMerchantCustomAttributeDefinitionsResponse, ApiException> prepareListMerchantCustomAttributeDefinitionsRequest(String visibilityFilter, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attribute-definitions").queryParam(param -> param.key("visibility_filter").value((Object)visibilityFilter).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListMerchantCustomAttributeDefinitionsResponse)ApiHelper.deserialize((String)response, ListMerchantCustomAttributeDefinitionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateMerchantCustomAttributeDefinitionResponse createMerchantCustomAttributeDefinition(CreateMerchantCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (CreateMerchantCustomAttributeDefinitionResponse)this.prepareCreateMerchantCustomAttributeDefinitionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateMerchantCustomAttributeDefinitionResponse> createMerchantCustomAttributeDefinitionAsync(CreateMerchantCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareCreateMerchantCustomAttributeDefinitionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateMerchantCustomAttributeDefinitionResponse, ApiException> prepareCreateMerchantCustomAttributeDefinitionRequest(CreateMerchantCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attribute-definitions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateMerchantCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, CreateMerchantCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteMerchantCustomAttributeDefinitionResponse deleteMerchantCustomAttributeDefinition(String key) throws ApiException, IOException {
        return (DeleteMerchantCustomAttributeDefinitionResponse)this.prepareDeleteMerchantCustomAttributeDefinitionRequest(key).execute();
    }

    @Override
    public CompletableFuture<DeleteMerchantCustomAttributeDefinitionResponse> deleteMerchantCustomAttributeDefinitionAsync(String key) {
        try {
            return this.prepareDeleteMerchantCustomAttributeDefinitionRequest(key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteMerchantCustomAttributeDefinitionResponse, ApiException> prepareDeleteMerchantCustomAttributeDefinitionRequest(String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attribute-definitions/{key}").templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteMerchantCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, DeleteMerchantCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveMerchantCustomAttributeDefinitionResponse retrieveMerchantCustomAttributeDefinition(String key, Integer version) throws ApiException, IOException {
        return (RetrieveMerchantCustomAttributeDefinitionResponse)this.prepareRetrieveMerchantCustomAttributeDefinitionRequest(key, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveMerchantCustomAttributeDefinitionResponse> retrieveMerchantCustomAttributeDefinitionAsync(String key, Integer version) {
        try {
            return this.prepareRetrieveMerchantCustomAttributeDefinitionRequest(key, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveMerchantCustomAttributeDefinitionResponse, ApiException> prepareRetrieveMerchantCustomAttributeDefinitionRequest(String key, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attribute-definitions/{key}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveMerchantCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, RetrieveMerchantCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateMerchantCustomAttributeDefinitionResponse updateMerchantCustomAttributeDefinition(String key, UpdateMerchantCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (UpdateMerchantCustomAttributeDefinitionResponse)this.prepareUpdateMerchantCustomAttributeDefinitionRequest(key, body).execute();
    }

    @Override
    public CompletableFuture<UpdateMerchantCustomAttributeDefinitionResponse> updateMerchantCustomAttributeDefinitionAsync(String key, UpdateMerchantCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareUpdateMerchantCustomAttributeDefinitionRequest(key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateMerchantCustomAttributeDefinitionResponse, ApiException> prepareUpdateMerchantCustomAttributeDefinitionRequest(String key, UpdateMerchantCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attribute-definitions/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateMerchantCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, UpdateMerchantCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkDeleteMerchantCustomAttributesResponse bulkDeleteMerchantCustomAttributes(BulkDeleteMerchantCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkDeleteMerchantCustomAttributesResponse)this.prepareBulkDeleteMerchantCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkDeleteMerchantCustomAttributesResponse> bulkDeleteMerchantCustomAttributesAsync(BulkDeleteMerchantCustomAttributesRequest body) {
        try {
            return this.prepareBulkDeleteMerchantCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkDeleteMerchantCustomAttributesResponse, ApiException> prepareBulkDeleteMerchantCustomAttributesRequest(BulkDeleteMerchantCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attributes/bulk-delete").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkDeleteMerchantCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkDeleteMerchantCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpsertMerchantCustomAttributesResponse bulkUpsertMerchantCustomAttributes(BulkUpsertMerchantCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkUpsertMerchantCustomAttributesResponse)this.prepareBulkUpsertMerchantCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpsertMerchantCustomAttributesResponse> bulkUpsertMerchantCustomAttributesAsync(BulkUpsertMerchantCustomAttributesRequest body) {
        try {
            return this.prepareBulkUpsertMerchantCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpsertMerchantCustomAttributesResponse, ApiException> prepareBulkUpsertMerchantCustomAttributesRequest(BulkUpsertMerchantCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/custom-attributes/bulk-upsert").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpsertMerchantCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkUpsertMerchantCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListMerchantCustomAttributesResponse listMerchantCustomAttributes(String merchantId, String visibilityFilter, Integer limit, String cursor, Boolean withDefinitions) throws ApiException, IOException {
        return (ListMerchantCustomAttributesResponse)this.prepareListMerchantCustomAttributesRequest(merchantId, visibilityFilter, limit, cursor, withDefinitions).execute();
    }

    @Override
    public CompletableFuture<ListMerchantCustomAttributesResponse> listMerchantCustomAttributesAsync(String merchantId, String visibilityFilter, Integer limit, String cursor, Boolean withDefinitions) {
        try {
            return this.prepareListMerchantCustomAttributesRequest(merchantId, visibilityFilter, limit, cursor, withDefinitions).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListMerchantCustomAttributesResponse, ApiException> prepareListMerchantCustomAttributesRequest(String merchantId, String visibilityFilter, Integer limit, String cursor, Boolean withDefinitions) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/{merchant_id}/custom-attributes").queryParam(param -> param.key("visibility_filter").value((Object)visibilityFilter).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("with_definitions").value((Object)(withDefinitions != null ? withDefinitions : false)).isRequired(false)).templateParam(param -> param.key("merchant_id").value((Object)merchantId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListMerchantCustomAttributesResponse)ApiHelper.deserialize((String)response, ListMerchantCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteMerchantCustomAttributeResponse deleteMerchantCustomAttribute(String merchantId, String key) throws ApiException, IOException {
        return (DeleteMerchantCustomAttributeResponse)this.prepareDeleteMerchantCustomAttributeRequest(merchantId, key).execute();
    }

    @Override
    public CompletableFuture<DeleteMerchantCustomAttributeResponse> deleteMerchantCustomAttributeAsync(String merchantId, String key) {
        try {
            return this.prepareDeleteMerchantCustomAttributeRequest(merchantId, key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteMerchantCustomAttributeResponse, ApiException> prepareDeleteMerchantCustomAttributeRequest(String merchantId, String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/{merchant_id}/custom-attributes/{key}").templateParam(param -> param.key("merchant_id").value((Object)merchantId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteMerchantCustomAttributeResponse)ApiHelper.deserialize((String)response, DeleteMerchantCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveMerchantCustomAttributeResponse retrieveMerchantCustomAttribute(String merchantId, String key, Boolean withDefinition, Integer version) throws ApiException, IOException {
        return (RetrieveMerchantCustomAttributeResponse)this.prepareRetrieveMerchantCustomAttributeRequest(merchantId, key, withDefinition, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveMerchantCustomAttributeResponse> retrieveMerchantCustomAttributeAsync(String merchantId, String key, Boolean withDefinition, Integer version) {
        try {
            return this.prepareRetrieveMerchantCustomAttributeRequest(merchantId, key, withDefinition, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveMerchantCustomAttributeResponse, ApiException> prepareRetrieveMerchantCustomAttributeRequest(String merchantId, String key, Boolean withDefinition, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/{merchant_id}/custom-attributes/{key}").queryParam(param -> param.key("with_definition").value((Object)(withDefinition != null ? withDefinition : false)).isRequired(false)).queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("merchant_id").value((Object)merchantId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveMerchantCustomAttributeResponse)ApiHelper.deserialize((String)response, RetrieveMerchantCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertMerchantCustomAttributeResponse upsertMerchantCustomAttribute(String merchantId, String key, UpsertMerchantCustomAttributeRequest body) throws ApiException, IOException {
        return (UpsertMerchantCustomAttributeResponse)this.prepareUpsertMerchantCustomAttributeRequest(merchantId, key, body).execute();
    }

    @Override
    public CompletableFuture<UpsertMerchantCustomAttributeResponse> upsertMerchantCustomAttributeAsync(String merchantId, String key, UpsertMerchantCustomAttributeRequest body) {
        try {
            return this.prepareUpsertMerchantCustomAttributeRequest(merchantId, key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertMerchantCustomAttributeResponse, ApiException> prepareUpsertMerchantCustomAttributeRequest(String merchantId, String key, UpsertMerchantCustomAttributeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/{merchant_id}/custom-attributes/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("merchant_id").value((Object)merchantId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertMerchantCustomAttributeResponse)ApiHelper.deserialize((String)response, UpsertMerchantCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

