/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.MerchantsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.ListMerchantsResponse;
import com.squareup.square.models.RetrieveMerchantResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultMerchantsApi
extends BaseApi
implements MerchantsApi {
    public DefaultMerchantsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListMerchantsResponse listMerchants(Integer cursor) throws ApiException, IOException {
        return (ListMerchantsResponse)this.prepareListMerchantsRequest(cursor).execute();
    }

    @Override
    public CompletableFuture<ListMerchantsResponse> listMerchantsAsync(Integer cursor) {
        try {
            return this.prepareListMerchantsRequest(cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListMerchantsResponse, ApiException> prepareListMerchantsRequest(Integer cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListMerchantsResponse)ApiHelper.deserialize((String)response, ListMerchantsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveMerchantResponse retrieveMerchant(String merchantId) throws ApiException, IOException {
        return (RetrieveMerchantResponse)this.prepareRetrieveMerchantRequest(merchantId).execute();
    }

    @Override
    public CompletableFuture<RetrieveMerchantResponse> retrieveMerchantAsync(String merchantId) {
        try {
            return this.prepareRetrieveMerchantRequest(merchantId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveMerchantResponse, ApiException> prepareRetrieveMerchantRequest(String merchantId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/merchants/{merchant_id}").templateParam(param -> param.key("merchant_id").value((Object)merchantId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveMerchantResponse)ApiHelper.deserialize((String)response, RetrieveMerchantResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

