/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.OrderCustomAttributesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkDeleteOrderCustomAttributesRequest;
import com.squareup.square.models.BulkDeleteOrderCustomAttributesResponse;
import com.squareup.square.models.BulkUpsertOrderCustomAttributesRequest;
import com.squareup.square.models.BulkUpsertOrderCustomAttributesResponse;
import com.squareup.square.models.CreateOrderCustomAttributeDefinitionRequest;
import com.squareup.square.models.CreateOrderCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteOrderCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteOrderCustomAttributeResponse;
import com.squareup.square.models.ListOrderCustomAttributeDefinitionsResponse;
import com.squareup.square.models.ListOrderCustomAttributesResponse;
import com.squareup.square.models.RetrieveOrderCustomAttributeDefinitionResponse;
import com.squareup.square.models.RetrieveOrderCustomAttributeResponse;
import com.squareup.square.models.UpdateOrderCustomAttributeDefinitionRequest;
import com.squareup.square.models.UpdateOrderCustomAttributeDefinitionResponse;
import com.squareup.square.models.UpsertOrderCustomAttributeRequest;
import com.squareup.square.models.UpsertOrderCustomAttributeResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultOrderCustomAttributesApi
extends BaseApi
implements OrderCustomAttributesApi {
    public DefaultOrderCustomAttributesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListOrderCustomAttributeDefinitionsResponse listOrderCustomAttributeDefinitions(String visibilityFilter, String cursor, Integer limit) throws ApiException, IOException {
        return (ListOrderCustomAttributeDefinitionsResponse)this.prepareListOrderCustomAttributeDefinitionsRequest(visibilityFilter, cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListOrderCustomAttributeDefinitionsResponse> listOrderCustomAttributeDefinitionsAsync(String visibilityFilter, String cursor, Integer limit) {
        try {
            return this.prepareListOrderCustomAttributeDefinitionsRequest(visibilityFilter, cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListOrderCustomAttributeDefinitionsResponse, ApiException> prepareListOrderCustomAttributeDefinitionsRequest(String visibilityFilter, String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attribute-definitions").queryParam(param -> param.key("visibility_filter").value((Object)visibilityFilter).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListOrderCustomAttributeDefinitionsResponse)ApiHelper.deserialize((String)response, ListOrderCustomAttributeDefinitionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateOrderCustomAttributeDefinitionResponse createOrderCustomAttributeDefinition(CreateOrderCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (CreateOrderCustomAttributeDefinitionResponse)this.prepareCreateOrderCustomAttributeDefinitionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateOrderCustomAttributeDefinitionResponse> createOrderCustomAttributeDefinitionAsync(CreateOrderCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareCreateOrderCustomAttributeDefinitionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateOrderCustomAttributeDefinitionResponse, ApiException> prepareCreateOrderCustomAttributeDefinitionRequest(CreateOrderCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attribute-definitions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateOrderCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, CreateOrderCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteOrderCustomAttributeDefinitionResponse deleteOrderCustomAttributeDefinition(String key) throws ApiException, IOException {
        return (DeleteOrderCustomAttributeDefinitionResponse)this.prepareDeleteOrderCustomAttributeDefinitionRequest(key).execute();
    }

    @Override
    public CompletableFuture<DeleteOrderCustomAttributeDefinitionResponse> deleteOrderCustomAttributeDefinitionAsync(String key) {
        try {
            return this.prepareDeleteOrderCustomAttributeDefinitionRequest(key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteOrderCustomAttributeDefinitionResponse, ApiException> prepareDeleteOrderCustomAttributeDefinitionRequest(String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attribute-definitions/{key}").templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteOrderCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, DeleteOrderCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveOrderCustomAttributeDefinitionResponse retrieveOrderCustomAttributeDefinition(String key, Integer version) throws ApiException, IOException {
        return (RetrieveOrderCustomAttributeDefinitionResponse)this.prepareRetrieveOrderCustomAttributeDefinitionRequest(key, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveOrderCustomAttributeDefinitionResponse> retrieveOrderCustomAttributeDefinitionAsync(String key, Integer version) {
        try {
            return this.prepareRetrieveOrderCustomAttributeDefinitionRequest(key, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveOrderCustomAttributeDefinitionResponse, ApiException> prepareRetrieveOrderCustomAttributeDefinitionRequest(String key, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attribute-definitions/{key}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveOrderCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, RetrieveOrderCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateOrderCustomAttributeDefinitionResponse updateOrderCustomAttributeDefinition(String key, UpdateOrderCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (UpdateOrderCustomAttributeDefinitionResponse)this.prepareUpdateOrderCustomAttributeDefinitionRequest(key, body).execute();
    }

    @Override
    public CompletableFuture<UpdateOrderCustomAttributeDefinitionResponse> updateOrderCustomAttributeDefinitionAsync(String key, UpdateOrderCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareUpdateOrderCustomAttributeDefinitionRequest(key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateOrderCustomAttributeDefinitionResponse, ApiException> prepareUpdateOrderCustomAttributeDefinitionRequest(String key, UpdateOrderCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attribute-definitions/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateOrderCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, UpdateOrderCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkDeleteOrderCustomAttributesResponse bulkDeleteOrderCustomAttributes(BulkDeleteOrderCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkDeleteOrderCustomAttributesResponse)this.prepareBulkDeleteOrderCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkDeleteOrderCustomAttributesResponse> bulkDeleteOrderCustomAttributesAsync(BulkDeleteOrderCustomAttributesRequest body) {
        try {
            return this.prepareBulkDeleteOrderCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkDeleteOrderCustomAttributesResponse, ApiException> prepareBulkDeleteOrderCustomAttributesRequest(BulkDeleteOrderCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attributes/bulk-delete").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkDeleteOrderCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkDeleteOrderCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpsertOrderCustomAttributesResponse bulkUpsertOrderCustomAttributes(BulkUpsertOrderCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkUpsertOrderCustomAttributesResponse)this.prepareBulkUpsertOrderCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpsertOrderCustomAttributesResponse> bulkUpsertOrderCustomAttributesAsync(BulkUpsertOrderCustomAttributesRequest body) {
        try {
            return this.prepareBulkUpsertOrderCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpsertOrderCustomAttributesResponse, ApiException> prepareBulkUpsertOrderCustomAttributesRequest(BulkUpsertOrderCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/custom-attributes/bulk-upsert").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpsertOrderCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkUpsertOrderCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListOrderCustomAttributesResponse listOrderCustomAttributes(String orderId, String visibilityFilter, String cursor, Integer limit, Boolean withDefinitions) throws ApiException, IOException {
        return (ListOrderCustomAttributesResponse)this.prepareListOrderCustomAttributesRequest(orderId, visibilityFilter, cursor, limit, withDefinitions).execute();
    }

    @Override
    public CompletableFuture<ListOrderCustomAttributesResponse> listOrderCustomAttributesAsync(String orderId, String visibilityFilter, String cursor, Integer limit, Boolean withDefinitions) {
        try {
            return this.prepareListOrderCustomAttributesRequest(orderId, visibilityFilter, cursor, limit, withDefinitions).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListOrderCustomAttributesResponse, ApiException> prepareListOrderCustomAttributesRequest(String orderId, String visibilityFilter, String cursor, Integer limit, Boolean withDefinitions) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}/custom-attributes").queryParam(param -> param.key("visibility_filter").value((Object)visibilityFilter).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("with_definitions").value((Object)(withDefinitions != null ? withDefinitions : false)).isRequired(false)).templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListOrderCustomAttributesResponse)ApiHelper.deserialize((String)response, ListOrderCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteOrderCustomAttributeResponse deleteOrderCustomAttribute(String orderId, String customAttributeKey) throws ApiException, IOException {
        return (DeleteOrderCustomAttributeResponse)this.prepareDeleteOrderCustomAttributeRequest(orderId, customAttributeKey).execute();
    }

    @Override
    public CompletableFuture<DeleteOrderCustomAttributeResponse> deleteOrderCustomAttributeAsync(String orderId, String customAttributeKey) {
        try {
            return this.prepareDeleteOrderCustomAttributeRequest(orderId, customAttributeKey).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteOrderCustomAttributeResponse, ApiException> prepareDeleteOrderCustomAttributeRequest(String orderId, String customAttributeKey) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}/custom-attributes/{custom_attribute_key}").templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).templateParam(param -> param.key("custom_attribute_key").value((Object)customAttributeKey).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteOrderCustomAttributeResponse)ApiHelper.deserialize((String)response, DeleteOrderCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveOrderCustomAttributeResponse retrieveOrderCustomAttribute(String orderId, String customAttributeKey, Integer version, Boolean withDefinition) throws ApiException, IOException {
        return (RetrieveOrderCustomAttributeResponse)this.prepareRetrieveOrderCustomAttributeRequest(orderId, customAttributeKey, version, withDefinition).execute();
    }

    @Override
    public CompletableFuture<RetrieveOrderCustomAttributeResponse> retrieveOrderCustomAttributeAsync(String orderId, String customAttributeKey, Integer version, Boolean withDefinition) {
        try {
            return this.prepareRetrieveOrderCustomAttributeRequest(orderId, customAttributeKey, version, withDefinition).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveOrderCustomAttributeResponse, ApiException> prepareRetrieveOrderCustomAttributeRequest(String orderId, String customAttributeKey, Integer version, Boolean withDefinition) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}/custom-attributes/{custom_attribute_key}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).queryParam(param -> param.key("with_definition").value((Object)(withDefinition != null ? withDefinition : false)).isRequired(false)).templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).templateParam(param -> param.key("custom_attribute_key").value((Object)customAttributeKey).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveOrderCustomAttributeResponse)ApiHelper.deserialize((String)response, RetrieveOrderCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertOrderCustomAttributeResponse upsertOrderCustomAttribute(String orderId, String customAttributeKey, UpsertOrderCustomAttributeRequest body) throws ApiException, IOException {
        return (UpsertOrderCustomAttributeResponse)this.prepareUpsertOrderCustomAttributeRequest(orderId, customAttributeKey, body).execute();
    }

    @Override
    public CompletableFuture<UpsertOrderCustomAttributeResponse> upsertOrderCustomAttributeAsync(String orderId, String customAttributeKey, UpsertOrderCustomAttributeRequest body) {
        try {
            return this.prepareUpsertOrderCustomAttributeRequest(orderId, customAttributeKey, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertOrderCustomAttributeResponse, ApiException> prepareUpsertOrderCustomAttributeRequest(String orderId, String customAttributeKey, UpsertOrderCustomAttributeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}/custom-attributes/{custom_attribute_key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).templateParam(param -> param.key("custom_attribute_key").value((Object)customAttributeKey).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertOrderCustomAttributeResponse)ApiHelper.deserialize((String)response, UpsertOrderCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

