/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.OrdersApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BatchRetrieveOrdersRequest;
import com.squareup.square.models.BatchRetrieveOrdersResponse;
import com.squareup.square.models.CalculateOrderRequest;
import com.squareup.square.models.CalculateOrderResponse;
import com.squareup.square.models.CloneOrderRequest;
import com.squareup.square.models.CloneOrderResponse;
import com.squareup.square.models.CreateOrderRequest;
import com.squareup.square.models.CreateOrderResponse;
import com.squareup.square.models.PayOrderRequest;
import com.squareup.square.models.PayOrderResponse;
import com.squareup.square.models.RetrieveOrderResponse;
import com.squareup.square.models.SearchOrdersRequest;
import com.squareup.square.models.SearchOrdersResponse;
import com.squareup.square.models.UpdateOrderRequest;
import com.squareup.square.models.UpdateOrderResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultOrdersApi
extends BaseApi
implements OrdersApi {
    public DefaultOrdersApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public CreateOrderResponse createOrder(CreateOrderRequest body) throws ApiException, IOException {
        return (CreateOrderResponse)this.prepareCreateOrderRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateOrderResponse> createOrderAsync(CreateOrderRequest body) {
        try {
            return this.prepareCreateOrderRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateOrderResponse, ApiException> prepareCreateOrderRequest(CreateOrderRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateOrderResponse)ApiHelper.deserialize((String)response, CreateOrderResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BatchRetrieveOrdersResponse batchRetrieveOrders(BatchRetrieveOrdersRequest body) throws ApiException, IOException {
        return (BatchRetrieveOrdersResponse)this.prepareBatchRetrieveOrdersRequest(body).execute();
    }

    @Override
    public CompletableFuture<BatchRetrieveOrdersResponse> batchRetrieveOrdersAsync(BatchRetrieveOrdersRequest body) {
        try {
            return this.prepareBatchRetrieveOrdersRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BatchRetrieveOrdersResponse, ApiException> prepareBatchRetrieveOrdersRequest(BatchRetrieveOrdersRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/batch-retrieve").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BatchRetrieveOrdersResponse)ApiHelper.deserialize((String)response, BatchRetrieveOrdersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CalculateOrderResponse calculateOrder(CalculateOrderRequest body) throws ApiException, IOException {
        return (CalculateOrderResponse)this.prepareCalculateOrderRequest(body).execute();
    }

    @Override
    public CompletableFuture<CalculateOrderResponse> calculateOrderAsync(CalculateOrderRequest body) {
        try {
            return this.prepareCalculateOrderRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CalculateOrderResponse, ApiException> prepareCalculateOrderRequest(CalculateOrderRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/calculate").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CalculateOrderResponse)ApiHelper.deserialize((String)response, CalculateOrderResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CloneOrderResponse cloneOrder(CloneOrderRequest body) throws ApiException, IOException {
        return (CloneOrderResponse)this.prepareCloneOrderRequest(body).execute();
    }

    @Override
    public CompletableFuture<CloneOrderResponse> cloneOrderAsync(CloneOrderRequest body) {
        try {
            return this.prepareCloneOrderRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CloneOrderResponse, ApiException> prepareCloneOrderRequest(CloneOrderRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/clone").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CloneOrderResponse)ApiHelper.deserialize((String)response, CloneOrderResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchOrdersResponse searchOrders(SearchOrdersRequest body) throws ApiException, IOException {
        return (SearchOrdersResponse)this.prepareSearchOrdersRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchOrdersResponse> searchOrdersAsync(SearchOrdersRequest body) {
        try {
            return this.prepareSearchOrdersRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchOrdersResponse, ApiException> prepareSearchOrdersRequest(SearchOrdersRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchOrdersResponse)ApiHelper.deserialize((String)response, SearchOrdersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveOrderResponse retrieveOrder(String orderId) throws ApiException, IOException {
        return (RetrieveOrderResponse)this.prepareRetrieveOrderRequest(orderId).execute();
    }

    @Override
    public CompletableFuture<RetrieveOrderResponse> retrieveOrderAsync(String orderId) {
        try {
            return this.prepareRetrieveOrderRequest(orderId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveOrderResponse, ApiException> prepareRetrieveOrderRequest(String orderId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}").templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveOrderResponse)ApiHelper.deserialize((String)response, RetrieveOrderResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateOrderResponse updateOrder(String orderId, UpdateOrderRequest body) throws ApiException, IOException {
        return (UpdateOrderResponse)this.prepareUpdateOrderRequest(orderId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateOrderResponse> updateOrderAsync(String orderId, UpdateOrderRequest body) {
        try {
            return this.prepareUpdateOrderRequest(orderId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateOrderResponse, ApiException> prepareUpdateOrderRequest(String orderId, UpdateOrderRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateOrderResponse)ApiHelper.deserialize((String)response, UpdateOrderResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public PayOrderResponse payOrder(String orderId, PayOrderRequest body) throws ApiException, IOException {
        return (PayOrderResponse)this.preparePayOrderRequest(orderId, body).execute();
    }

    @Override
    public CompletableFuture<PayOrderResponse> payOrderAsync(String orderId, PayOrderRequest body) {
        try {
            return this.preparePayOrderRequest(orderId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<PayOrderResponse, ApiException> preparePayOrderRequest(String orderId, PayOrderRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/orders/{order_id}/pay").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("order_id").value((Object)orderId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (PayOrderResponse)ApiHelper.deserialize((String)response, PayOrderResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

