/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.PayoutsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.GetPayoutResponse;
import com.squareup.square.models.ListPayoutEntriesResponse;
import com.squareup.square.models.ListPayoutsResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultPayoutsApi
extends BaseApi
implements PayoutsApi {
    public DefaultPayoutsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListPayoutsResponse listPayouts(String locationId, String status, String beginTime, String endTime, String sortOrder, String cursor, Integer limit) throws ApiException, IOException {
        return (ListPayoutsResponse)this.prepareListPayoutsRequest(locationId, status, beginTime, endTime, sortOrder, cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListPayoutsResponse> listPayoutsAsync(String locationId, String status, String beginTime, String endTime, String sortOrder, String cursor, Integer limit) {
        try {
            return this.prepareListPayoutsRequest(locationId, status, beginTime, endTime, sortOrder, cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListPayoutsResponse, ApiException> prepareListPayoutsRequest(String locationId, String status, String beginTime, String endTime, String sortOrder, String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payouts").queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("status").value((Object)status).isRequired(false)).queryParam(param -> param.key("begin_time").value((Object)beginTime).isRequired(false)).queryParam(param -> param.key("end_time").value((Object)endTime).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListPayoutsResponse)ApiHelper.deserialize((String)response, ListPayoutsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetPayoutResponse getPayout(String payoutId) throws ApiException, IOException {
        return (GetPayoutResponse)this.prepareGetPayoutRequest(payoutId).execute();
    }

    @Override
    public CompletableFuture<GetPayoutResponse> getPayoutAsync(String payoutId) {
        try {
            return this.prepareGetPayoutRequest(payoutId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetPayoutResponse, ApiException> prepareGetPayoutRequest(String payoutId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payouts/{payout_id}").templateParam(param -> param.key("payout_id").value((Object)payoutId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetPayoutResponse)ApiHelper.deserialize((String)response, GetPayoutResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListPayoutEntriesResponse listPayoutEntries(String payoutId, String sortOrder, String cursor, Integer limit) throws ApiException, IOException {
        return (ListPayoutEntriesResponse)this.prepareListPayoutEntriesRequest(payoutId, sortOrder, cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListPayoutEntriesResponse> listPayoutEntriesAsync(String payoutId, String sortOrder, String cursor, Integer limit) {
        try {
            return this.prepareListPayoutEntriesRequest(payoutId, sortOrder, cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListPayoutEntriesResponse, ApiException> prepareListPayoutEntriesRequest(String payoutId, String sortOrder, String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payouts/{payout_id}/payout-entries").queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).templateParam(param -> param.key("payout_id").value((Object)payoutId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListPayoutEntriesResponse)ApiHelper.deserialize((String)response, ListPayoutEntriesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

