/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.RefundsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.GetPaymentRefundResponse;
import com.squareup.square.models.ListPaymentRefundsResponse;
import com.squareup.square.models.RefundPaymentRequest;
import com.squareup.square.models.RefundPaymentResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultRefundsApi
extends BaseApi
implements RefundsApi {
    public DefaultRefundsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListPaymentRefundsResponse listPaymentRefunds(String beginTime, String endTime, String sortOrder, String cursor, String locationId, String status, String sourceType, Integer limit) throws ApiException, IOException {
        return (ListPaymentRefundsResponse)this.prepareListPaymentRefundsRequest(beginTime, endTime, sortOrder, cursor, locationId, status, sourceType, limit).execute();
    }

    @Override
    public CompletableFuture<ListPaymentRefundsResponse> listPaymentRefundsAsync(String beginTime, String endTime, String sortOrder, String cursor, String locationId, String status, String sourceType, Integer limit) {
        try {
            return this.prepareListPaymentRefundsRequest(beginTime, endTime, sortOrder, cursor, locationId, status, sourceType, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListPaymentRefundsResponse, ApiException> prepareListPaymentRefundsRequest(String beginTime, String endTime, String sortOrder, String cursor, String locationId, String status, String sourceType, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/refunds").queryParam(param -> param.key("begin_time").value((Object)beginTime).isRequired(false)).queryParam(param -> param.key("end_time").value((Object)endTime).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("status").value((Object)status).isRequired(false)).queryParam(param -> param.key("source_type").value((Object)sourceType).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListPaymentRefundsResponse)ApiHelper.deserialize((String)response, ListPaymentRefundsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RefundPaymentResponse refundPayment(RefundPaymentRequest body) throws ApiException, IOException {
        return (RefundPaymentResponse)this.prepareRefundPaymentRequest(body).execute();
    }

    @Override
    public CompletableFuture<RefundPaymentResponse> refundPaymentAsync(RefundPaymentRequest body) {
        try {
            return this.prepareRefundPaymentRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RefundPaymentResponse, ApiException> prepareRefundPaymentRequest(RefundPaymentRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/refunds").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RefundPaymentResponse)ApiHelper.deserialize((String)response, RefundPaymentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetPaymentRefundResponse getPaymentRefund(String refundId) throws ApiException, IOException {
        return (GetPaymentRefundResponse)this.prepareGetPaymentRefundRequest(refundId).execute();
    }

    @Override
    public CompletableFuture<GetPaymentRefundResponse> getPaymentRefundAsync(String refundId) {
        try {
            return this.prepareGetPaymentRefundRequest(refundId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetPaymentRefundResponse, ApiException> prepareGetPaymentRefundRequest(String refundId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/refunds/{refund_id}").templateParam(param -> param.key("refund_id").value((Object)refundId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetPaymentRefundResponse)ApiHelper.deserialize((String)response, GetPaymentRefundResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

