/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.SnippetsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.DeleteSnippetResponse;
import com.squareup.square.models.RetrieveSnippetResponse;
import com.squareup.square.models.UpsertSnippetRequest;
import com.squareup.square.models.UpsertSnippetResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultSnippetsApi
extends BaseApi
implements SnippetsApi {
    public DefaultSnippetsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public DeleteSnippetResponse deleteSnippet(String siteId) throws ApiException, IOException {
        return (DeleteSnippetResponse)this.prepareDeleteSnippetRequest(siteId).execute();
    }

    @Override
    public CompletableFuture<DeleteSnippetResponse> deleteSnippetAsync(String siteId) {
        try {
            return this.prepareDeleteSnippetRequest(siteId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteSnippetResponse, ApiException> prepareDeleteSnippetRequest(String siteId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/sites/{site_id}/snippet").templateParam(param -> param.key("site_id").value((Object)siteId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteSnippetResponse)ApiHelper.deserialize((String)response, DeleteSnippetResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveSnippetResponse retrieveSnippet(String siteId) throws ApiException, IOException {
        return (RetrieveSnippetResponse)this.prepareRetrieveSnippetRequest(siteId).execute();
    }

    @Override
    public CompletableFuture<RetrieveSnippetResponse> retrieveSnippetAsync(String siteId) {
        try {
            return this.prepareRetrieveSnippetRequest(siteId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveSnippetResponse, ApiException> prepareRetrieveSnippetRequest(String siteId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/sites/{site_id}/snippet").templateParam(param -> param.key("site_id").value((Object)siteId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveSnippetResponse)ApiHelper.deserialize((String)response, RetrieveSnippetResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertSnippetResponse upsertSnippet(String siteId, UpsertSnippetRequest body) throws ApiException, IOException {
        return (UpsertSnippetResponse)this.prepareUpsertSnippetRequest(siteId, body).execute();
    }

    @Override
    public CompletableFuture<UpsertSnippetResponse> upsertSnippetAsync(String siteId, UpsertSnippetRequest body) {
        try {
            return this.prepareUpsertSnippetRequest(siteId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertSnippetResponse, ApiException> prepareUpsertSnippetRequest(String siteId, UpsertSnippetRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/sites/{site_id}/snippet").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("site_id").value((Object)siteId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertSnippetResponse)ApiHelper.deserialize((String)response, UpsertSnippetResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

