/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.SubscriptionsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkSwapPlanRequest;
import com.squareup.square.models.BulkSwapPlanResponse;
import com.squareup.square.models.CancelSubscriptionResponse;
import com.squareup.square.models.ChangeBillingAnchorDateRequest;
import com.squareup.square.models.ChangeBillingAnchorDateResponse;
import com.squareup.square.models.CreateSubscriptionRequest;
import com.squareup.square.models.CreateSubscriptionResponse;
import com.squareup.square.models.DeleteSubscriptionActionResponse;
import com.squareup.square.models.ListSubscriptionEventsResponse;
import com.squareup.square.models.PauseSubscriptionRequest;
import com.squareup.square.models.PauseSubscriptionResponse;
import com.squareup.square.models.ResumeSubscriptionRequest;
import com.squareup.square.models.ResumeSubscriptionResponse;
import com.squareup.square.models.RetrieveSubscriptionResponse;
import com.squareup.square.models.SearchSubscriptionsRequest;
import com.squareup.square.models.SearchSubscriptionsResponse;
import com.squareup.square.models.SwapPlanRequest;
import com.squareup.square.models.SwapPlanResponse;
import com.squareup.square.models.UpdateSubscriptionRequest;
import com.squareup.square.models.UpdateSubscriptionResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultSubscriptionsApi
extends BaseApi
implements SubscriptionsApi {
    public DefaultSubscriptionsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest body) throws ApiException, IOException {
        return (CreateSubscriptionResponse)this.prepareCreateSubscriptionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateSubscriptionResponse> createSubscriptionAsync(CreateSubscriptionRequest body) {
        try {
            return this.prepareCreateSubscriptionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateSubscriptionResponse, ApiException> prepareCreateSubscriptionRequest(CreateSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateSubscriptionResponse)ApiHelper.deserialize((String)response, CreateSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkSwapPlanResponse bulkSwapPlan(BulkSwapPlanRequest body) throws ApiException, IOException {
        return (BulkSwapPlanResponse)this.prepareBulkSwapPlanRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkSwapPlanResponse> bulkSwapPlanAsync(BulkSwapPlanRequest body) {
        try {
            return this.prepareBulkSwapPlanRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkSwapPlanResponse, ApiException> prepareBulkSwapPlanRequest(BulkSwapPlanRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/bulk-swap-plan").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkSwapPlanResponse)ApiHelper.deserialize((String)response, BulkSwapPlanResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchSubscriptionsResponse searchSubscriptions(SearchSubscriptionsRequest body) throws ApiException, IOException {
        return (SearchSubscriptionsResponse)this.prepareSearchSubscriptionsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchSubscriptionsResponse> searchSubscriptionsAsync(SearchSubscriptionsRequest body) {
        try {
            return this.prepareSearchSubscriptionsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchSubscriptionsResponse, ApiException> prepareSearchSubscriptionsRequest(SearchSubscriptionsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchSubscriptionsResponse)ApiHelper.deserialize((String)response, SearchSubscriptionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveSubscriptionResponse retrieveSubscription(String subscriptionId, String include) throws ApiException, IOException {
        return (RetrieveSubscriptionResponse)this.prepareRetrieveSubscriptionRequest(subscriptionId, include).execute();
    }

    @Override
    public CompletableFuture<RetrieveSubscriptionResponse> retrieveSubscriptionAsync(String subscriptionId, String include) {
        try {
            return this.prepareRetrieveSubscriptionRequest(subscriptionId, include).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveSubscriptionResponse, ApiException> prepareRetrieveSubscriptionRequest(String subscriptionId, String include) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}").queryParam(param -> param.key("include").value((Object)include).isRequired(false)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveSubscriptionResponse)ApiHelper.deserialize((String)response, RetrieveSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateSubscriptionResponse updateSubscription(String subscriptionId, UpdateSubscriptionRequest body) throws ApiException, IOException {
        return (UpdateSubscriptionResponse)this.prepareUpdateSubscriptionRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateSubscriptionResponse> updateSubscriptionAsync(String subscriptionId, UpdateSubscriptionRequest body) {
        try {
            return this.prepareUpdateSubscriptionRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateSubscriptionResponse, ApiException> prepareUpdateSubscriptionRequest(String subscriptionId, UpdateSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateSubscriptionResponse)ApiHelper.deserialize((String)response, UpdateSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteSubscriptionActionResponse deleteSubscriptionAction(String subscriptionId, String actionId) throws ApiException, IOException {
        return (DeleteSubscriptionActionResponse)this.prepareDeleteSubscriptionActionRequest(subscriptionId, actionId).execute();
    }

    @Override
    public CompletableFuture<DeleteSubscriptionActionResponse> deleteSubscriptionActionAsync(String subscriptionId, String actionId) {
        try {
            return this.prepareDeleteSubscriptionActionRequest(subscriptionId, actionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteSubscriptionActionResponse, ApiException> prepareDeleteSubscriptionActionRequest(String subscriptionId, String actionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/actions/{action_id}").templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).templateParam(param -> param.key("action_id").value((Object)actionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteSubscriptionActionResponse)ApiHelper.deserialize((String)response, DeleteSubscriptionActionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ChangeBillingAnchorDateResponse changeBillingAnchorDate(String subscriptionId, ChangeBillingAnchorDateRequest body) throws ApiException, IOException {
        return (ChangeBillingAnchorDateResponse)this.prepareChangeBillingAnchorDateRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<ChangeBillingAnchorDateResponse> changeBillingAnchorDateAsync(String subscriptionId, ChangeBillingAnchorDateRequest body) {
        try {
            return this.prepareChangeBillingAnchorDateRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ChangeBillingAnchorDateResponse, ApiException> prepareChangeBillingAnchorDateRequest(String subscriptionId, ChangeBillingAnchorDateRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/billing-anchor").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ChangeBillingAnchorDateResponse)ApiHelper.deserialize((String)response, ChangeBillingAnchorDateResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelSubscriptionResponse cancelSubscription(String subscriptionId) throws ApiException, IOException {
        return (CancelSubscriptionResponse)this.prepareCancelSubscriptionRequest(subscriptionId).execute();
    }

    @Override
    public CompletableFuture<CancelSubscriptionResponse> cancelSubscriptionAsync(String subscriptionId) {
        try {
            return this.prepareCancelSubscriptionRequest(subscriptionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelSubscriptionResponse, ApiException> prepareCancelSubscriptionRequest(String subscriptionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/cancel").templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelSubscriptionResponse)ApiHelper.deserialize((String)response, CancelSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListSubscriptionEventsResponse listSubscriptionEvents(String subscriptionId, String cursor, Integer limit) throws ApiException, IOException {
        return (ListSubscriptionEventsResponse)this.prepareListSubscriptionEventsRequest(subscriptionId, cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListSubscriptionEventsResponse> listSubscriptionEventsAsync(String subscriptionId, String cursor, Integer limit) {
        try {
            return this.prepareListSubscriptionEventsRequest(subscriptionId, cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListSubscriptionEventsResponse, ApiException> prepareListSubscriptionEventsRequest(String subscriptionId, String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/events").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListSubscriptionEventsResponse)ApiHelper.deserialize((String)response, ListSubscriptionEventsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public PauseSubscriptionResponse pauseSubscription(String subscriptionId, PauseSubscriptionRequest body) throws ApiException, IOException {
        return (PauseSubscriptionResponse)this.preparePauseSubscriptionRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<PauseSubscriptionResponse> pauseSubscriptionAsync(String subscriptionId, PauseSubscriptionRequest body) {
        try {
            return this.preparePauseSubscriptionRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<PauseSubscriptionResponse, ApiException> preparePauseSubscriptionRequest(String subscriptionId, PauseSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/pause").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (PauseSubscriptionResponse)ApiHelper.deserialize((String)response, PauseSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ResumeSubscriptionResponse resumeSubscription(String subscriptionId, ResumeSubscriptionRequest body) throws ApiException, IOException {
        return (ResumeSubscriptionResponse)this.prepareResumeSubscriptionRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<ResumeSubscriptionResponse> resumeSubscriptionAsync(String subscriptionId, ResumeSubscriptionRequest body) {
        try {
            return this.prepareResumeSubscriptionRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ResumeSubscriptionResponse, ApiException> prepareResumeSubscriptionRequest(String subscriptionId, ResumeSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/resume").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ResumeSubscriptionResponse)ApiHelper.deserialize((String)response, ResumeSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SwapPlanResponse swapPlan(String subscriptionId, SwapPlanRequest body) throws ApiException, IOException {
        return (SwapPlanResponse)this.prepareSwapPlanRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<SwapPlanResponse> swapPlanAsync(String subscriptionId, SwapPlanRequest body) {
        try {
            return this.prepareSwapPlanRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SwapPlanResponse, ApiException> prepareSwapPlanRequest(String subscriptionId, SwapPlanRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/subscriptions/{subscription_id}/swap-plan").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SwapPlanResponse)ApiHelper.deserialize((String)response, SwapPlanResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

