/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.TeamApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkCreateTeamMembersRequest;
import com.squareup.square.models.BulkCreateTeamMembersResponse;
import com.squareup.square.models.BulkUpdateTeamMembersRequest;
import com.squareup.square.models.BulkUpdateTeamMembersResponse;
import com.squareup.square.models.CreateTeamMemberRequest;
import com.squareup.square.models.CreateTeamMemberResponse;
import com.squareup.square.models.RetrieveTeamMemberResponse;
import com.squareup.square.models.RetrieveWageSettingResponse;
import com.squareup.square.models.SearchTeamMembersRequest;
import com.squareup.square.models.SearchTeamMembersResponse;
import com.squareup.square.models.UpdateTeamMemberRequest;
import com.squareup.square.models.UpdateTeamMemberResponse;
import com.squareup.square.models.UpdateWageSettingRequest;
import com.squareup.square.models.UpdateWageSettingResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultTeamApi
extends BaseApi
implements TeamApi {
    public DefaultTeamApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public CreateTeamMemberResponse createTeamMember(CreateTeamMemberRequest body) throws ApiException, IOException {
        return (CreateTeamMemberResponse)this.prepareCreateTeamMemberRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateTeamMemberResponse> createTeamMemberAsync(CreateTeamMemberRequest body) {
        try {
            return this.prepareCreateTeamMemberRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateTeamMemberResponse, ApiException> prepareCreateTeamMemberRequest(CreateTeamMemberRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateTeamMemberResponse)ApiHelper.deserialize((String)response, CreateTeamMemberResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkCreateTeamMembersResponse bulkCreateTeamMembers(BulkCreateTeamMembersRequest body) throws ApiException, IOException {
        return (BulkCreateTeamMembersResponse)this.prepareBulkCreateTeamMembersRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkCreateTeamMembersResponse> bulkCreateTeamMembersAsync(BulkCreateTeamMembersRequest body) {
        try {
            return this.prepareBulkCreateTeamMembersRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkCreateTeamMembersResponse, ApiException> prepareBulkCreateTeamMembersRequest(BulkCreateTeamMembersRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/bulk-create").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkCreateTeamMembersResponse)ApiHelper.deserialize((String)response, BulkCreateTeamMembersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpdateTeamMembersResponse bulkUpdateTeamMembers(BulkUpdateTeamMembersRequest body) throws ApiException, IOException {
        return (BulkUpdateTeamMembersResponse)this.prepareBulkUpdateTeamMembersRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpdateTeamMembersResponse> bulkUpdateTeamMembersAsync(BulkUpdateTeamMembersRequest body) {
        try {
            return this.prepareBulkUpdateTeamMembersRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpdateTeamMembersResponse, ApiException> prepareBulkUpdateTeamMembersRequest(BulkUpdateTeamMembersRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/bulk-update").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpdateTeamMembersResponse)ApiHelper.deserialize((String)response, BulkUpdateTeamMembersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchTeamMembersResponse searchTeamMembers(SearchTeamMembersRequest body) throws ApiException, IOException {
        return (SearchTeamMembersResponse)this.prepareSearchTeamMembersRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchTeamMembersResponse> searchTeamMembersAsync(SearchTeamMembersRequest body) {
        try {
            return this.prepareSearchTeamMembersRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchTeamMembersResponse, ApiException> prepareSearchTeamMembersRequest(SearchTeamMembersRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchTeamMembersResponse)ApiHelper.deserialize((String)response, SearchTeamMembersResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveTeamMemberResponse retrieveTeamMember(String teamMemberId) throws ApiException, IOException {
        return (RetrieveTeamMemberResponse)this.prepareRetrieveTeamMemberRequest(teamMemberId).execute();
    }

    @Override
    public CompletableFuture<RetrieveTeamMemberResponse> retrieveTeamMemberAsync(String teamMemberId) {
        try {
            return this.prepareRetrieveTeamMemberRequest(teamMemberId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveTeamMemberResponse, ApiException> prepareRetrieveTeamMemberRequest(String teamMemberId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/{team_member_id}").templateParam(param -> param.key("team_member_id").value((Object)teamMemberId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveTeamMemberResponse)ApiHelper.deserialize((String)response, RetrieveTeamMemberResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateTeamMemberResponse updateTeamMember(String teamMemberId, UpdateTeamMemberRequest body) throws ApiException, IOException {
        return (UpdateTeamMemberResponse)this.prepareUpdateTeamMemberRequest(teamMemberId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateTeamMemberResponse> updateTeamMemberAsync(String teamMemberId, UpdateTeamMemberRequest body) {
        try {
            return this.prepareUpdateTeamMemberRequest(teamMemberId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateTeamMemberResponse, ApiException> prepareUpdateTeamMemberRequest(String teamMemberId, UpdateTeamMemberRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/{team_member_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("team_member_id").value((Object)teamMemberId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateTeamMemberResponse)ApiHelper.deserialize((String)response, UpdateTeamMemberResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveWageSettingResponse retrieveWageSetting(String teamMemberId) throws ApiException, IOException {
        return (RetrieveWageSettingResponse)this.prepareRetrieveWageSettingRequest(teamMemberId).execute();
    }

    @Override
    public CompletableFuture<RetrieveWageSettingResponse> retrieveWageSettingAsync(String teamMemberId) {
        try {
            return this.prepareRetrieveWageSettingRequest(teamMemberId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveWageSettingResponse, ApiException> prepareRetrieveWageSettingRequest(String teamMemberId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/{team_member_id}/wage-setting").templateParam(param -> param.key("team_member_id").value((Object)teamMemberId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveWageSettingResponse)ApiHelper.deserialize((String)response, RetrieveWageSettingResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateWageSettingResponse updateWageSetting(String teamMemberId, UpdateWageSettingRequest body) throws ApiException, IOException {
        return (UpdateWageSettingResponse)this.prepareUpdateWageSettingRequest(teamMemberId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateWageSettingResponse> updateWageSettingAsync(String teamMemberId, UpdateWageSettingRequest body) {
        try {
            return this.prepareUpdateWageSettingRequest(teamMemberId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateWageSettingResponse, ApiException> prepareUpdateWageSettingRequest(String teamMemberId, UpdateWageSettingRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/team-members/{team_member_id}/wage-setting").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("team_member_id").value((Object)teamMemberId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateWageSettingResponse)ApiHelper.deserialize((String)response, UpdateWageSettingResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

