/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.TerminalApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CancelTerminalActionResponse;
import com.squareup.square.models.CancelTerminalCheckoutResponse;
import com.squareup.square.models.CancelTerminalRefundResponse;
import com.squareup.square.models.CreateTerminalActionRequest;
import com.squareup.square.models.CreateTerminalActionResponse;
import com.squareup.square.models.CreateTerminalCheckoutRequest;
import com.squareup.square.models.CreateTerminalCheckoutResponse;
import com.squareup.square.models.CreateTerminalRefundRequest;
import com.squareup.square.models.CreateTerminalRefundResponse;
import com.squareup.square.models.DismissTerminalActionResponse;
import com.squareup.square.models.DismissTerminalCheckoutResponse;
import com.squareup.square.models.DismissTerminalRefundResponse;
import com.squareup.square.models.GetTerminalActionResponse;
import com.squareup.square.models.GetTerminalCheckoutResponse;
import com.squareup.square.models.GetTerminalRefundResponse;
import com.squareup.square.models.SearchTerminalActionsRequest;
import com.squareup.square.models.SearchTerminalActionsResponse;
import com.squareup.square.models.SearchTerminalCheckoutsRequest;
import com.squareup.square.models.SearchTerminalCheckoutsResponse;
import com.squareup.square.models.SearchTerminalRefundsRequest;
import com.squareup.square.models.SearchTerminalRefundsResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultTerminalApi
extends BaseApi
implements TerminalApi {
    public DefaultTerminalApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public CreateTerminalActionResponse createTerminalAction(CreateTerminalActionRequest body) throws ApiException, IOException {
        return (CreateTerminalActionResponse)this.prepareCreateTerminalActionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateTerminalActionResponse> createTerminalActionAsync(CreateTerminalActionRequest body) {
        try {
            return this.prepareCreateTerminalActionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateTerminalActionResponse, ApiException> prepareCreateTerminalActionRequest(CreateTerminalActionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/actions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateTerminalActionResponse)ApiHelper.deserialize((String)response, CreateTerminalActionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchTerminalActionsResponse searchTerminalActions(SearchTerminalActionsRequest body) throws ApiException, IOException {
        return (SearchTerminalActionsResponse)this.prepareSearchTerminalActionsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchTerminalActionsResponse> searchTerminalActionsAsync(SearchTerminalActionsRequest body) {
        try {
            return this.prepareSearchTerminalActionsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchTerminalActionsResponse, ApiException> prepareSearchTerminalActionsRequest(SearchTerminalActionsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/actions/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchTerminalActionsResponse)ApiHelper.deserialize((String)response, SearchTerminalActionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetTerminalActionResponse getTerminalAction(String actionId) throws ApiException, IOException {
        return (GetTerminalActionResponse)this.prepareGetTerminalActionRequest(actionId).execute();
    }

    @Override
    public CompletableFuture<GetTerminalActionResponse> getTerminalActionAsync(String actionId) {
        try {
            return this.prepareGetTerminalActionRequest(actionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetTerminalActionResponse, ApiException> prepareGetTerminalActionRequest(String actionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/actions/{action_id}").templateParam(param -> param.key("action_id").value((Object)actionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetTerminalActionResponse)ApiHelper.deserialize((String)response, GetTerminalActionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelTerminalActionResponse cancelTerminalAction(String actionId) throws ApiException, IOException {
        return (CancelTerminalActionResponse)this.prepareCancelTerminalActionRequest(actionId).execute();
    }

    @Override
    public CompletableFuture<CancelTerminalActionResponse> cancelTerminalActionAsync(String actionId) {
        try {
            return this.prepareCancelTerminalActionRequest(actionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelTerminalActionResponse, ApiException> prepareCancelTerminalActionRequest(String actionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/actions/{action_id}/cancel").templateParam(param -> param.key("action_id").value((Object)actionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelTerminalActionResponse)ApiHelper.deserialize((String)response, CancelTerminalActionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DismissTerminalActionResponse dismissTerminalAction(String actionId) throws ApiException, IOException {
        return (DismissTerminalActionResponse)this.prepareDismissTerminalActionRequest(actionId).execute();
    }

    @Override
    public CompletableFuture<DismissTerminalActionResponse> dismissTerminalActionAsync(String actionId) {
        try {
            return this.prepareDismissTerminalActionRequest(actionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DismissTerminalActionResponse, ApiException> prepareDismissTerminalActionRequest(String actionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/actions/{action_id}/dismiss").templateParam(param -> param.key("action_id").value((Object)actionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DismissTerminalActionResponse)ApiHelper.deserialize((String)response, DismissTerminalActionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateTerminalCheckoutResponse createTerminalCheckout(CreateTerminalCheckoutRequest body) throws ApiException, IOException {
        return (CreateTerminalCheckoutResponse)this.prepareCreateTerminalCheckoutRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateTerminalCheckoutResponse> createTerminalCheckoutAsync(CreateTerminalCheckoutRequest body) {
        try {
            return this.prepareCreateTerminalCheckoutRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateTerminalCheckoutResponse, ApiException> prepareCreateTerminalCheckoutRequest(CreateTerminalCheckoutRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/checkouts").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateTerminalCheckoutResponse)ApiHelper.deserialize((String)response, CreateTerminalCheckoutResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchTerminalCheckoutsResponse searchTerminalCheckouts(SearchTerminalCheckoutsRequest body) throws ApiException, IOException {
        return (SearchTerminalCheckoutsResponse)this.prepareSearchTerminalCheckoutsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchTerminalCheckoutsResponse> searchTerminalCheckoutsAsync(SearchTerminalCheckoutsRequest body) {
        try {
            return this.prepareSearchTerminalCheckoutsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchTerminalCheckoutsResponse, ApiException> prepareSearchTerminalCheckoutsRequest(SearchTerminalCheckoutsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/checkouts/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchTerminalCheckoutsResponse)ApiHelper.deserialize((String)response, SearchTerminalCheckoutsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetTerminalCheckoutResponse getTerminalCheckout(String checkoutId) throws ApiException, IOException {
        return (GetTerminalCheckoutResponse)this.prepareGetTerminalCheckoutRequest(checkoutId).execute();
    }

    @Override
    public CompletableFuture<GetTerminalCheckoutResponse> getTerminalCheckoutAsync(String checkoutId) {
        try {
            return this.prepareGetTerminalCheckoutRequest(checkoutId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetTerminalCheckoutResponse, ApiException> prepareGetTerminalCheckoutRequest(String checkoutId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/checkouts/{checkout_id}").templateParam(param -> param.key("checkout_id").value((Object)checkoutId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetTerminalCheckoutResponse)ApiHelper.deserialize((String)response, GetTerminalCheckoutResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelTerminalCheckoutResponse cancelTerminalCheckout(String checkoutId) throws ApiException, IOException {
        return (CancelTerminalCheckoutResponse)this.prepareCancelTerminalCheckoutRequest(checkoutId).execute();
    }

    @Override
    public CompletableFuture<CancelTerminalCheckoutResponse> cancelTerminalCheckoutAsync(String checkoutId) {
        try {
            return this.prepareCancelTerminalCheckoutRequest(checkoutId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelTerminalCheckoutResponse, ApiException> prepareCancelTerminalCheckoutRequest(String checkoutId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/checkouts/{checkout_id}/cancel").templateParam(param -> param.key("checkout_id").value((Object)checkoutId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelTerminalCheckoutResponse)ApiHelper.deserialize((String)response, CancelTerminalCheckoutResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DismissTerminalCheckoutResponse dismissTerminalCheckout(String checkoutId) throws ApiException, IOException {
        return (DismissTerminalCheckoutResponse)this.prepareDismissTerminalCheckoutRequest(checkoutId).execute();
    }

    @Override
    public CompletableFuture<DismissTerminalCheckoutResponse> dismissTerminalCheckoutAsync(String checkoutId) {
        try {
            return this.prepareDismissTerminalCheckoutRequest(checkoutId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DismissTerminalCheckoutResponse, ApiException> prepareDismissTerminalCheckoutRequest(String checkoutId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/checkouts/{checkout_id}/dismiss").templateParam(param -> param.key("checkout_id").value((Object)checkoutId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DismissTerminalCheckoutResponse)ApiHelper.deserialize((String)response, DismissTerminalCheckoutResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateTerminalRefundResponse createTerminalRefund(CreateTerminalRefundRequest body) throws ApiException, IOException {
        return (CreateTerminalRefundResponse)this.prepareCreateTerminalRefundRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateTerminalRefundResponse> createTerminalRefundAsync(CreateTerminalRefundRequest body) {
        try {
            return this.prepareCreateTerminalRefundRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateTerminalRefundResponse, ApiException> prepareCreateTerminalRefundRequest(CreateTerminalRefundRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/refunds").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateTerminalRefundResponse)ApiHelper.deserialize((String)response, CreateTerminalRefundResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchTerminalRefundsResponse searchTerminalRefunds(SearchTerminalRefundsRequest body) throws ApiException, IOException {
        return (SearchTerminalRefundsResponse)this.prepareSearchTerminalRefundsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchTerminalRefundsResponse> searchTerminalRefundsAsync(SearchTerminalRefundsRequest body) {
        try {
            return this.prepareSearchTerminalRefundsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchTerminalRefundsResponse, ApiException> prepareSearchTerminalRefundsRequest(SearchTerminalRefundsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/refunds/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchTerminalRefundsResponse)ApiHelper.deserialize((String)response, SearchTerminalRefundsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetTerminalRefundResponse getTerminalRefund(String terminalRefundId) throws ApiException, IOException {
        return (GetTerminalRefundResponse)this.prepareGetTerminalRefundRequest(terminalRefundId).execute();
    }

    @Override
    public CompletableFuture<GetTerminalRefundResponse> getTerminalRefundAsync(String terminalRefundId) {
        try {
            return this.prepareGetTerminalRefundRequest(terminalRefundId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetTerminalRefundResponse, ApiException> prepareGetTerminalRefundRequest(String terminalRefundId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/refunds/{terminal_refund_id}").templateParam(param -> param.key("terminal_refund_id").value((Object)terminalRefundId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetTerminalRefundResponse)ApiHelper.deserialize((String)response, GetTerminalRefundResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelTerminalRefundResponse cancelTerminalRefund(String terminalRefundId) throws ApiException, IOException {
        return (CancelTerminalRefundResponse)this.prepareCancelTerminalRefundRequest(terminalRefundId).execute();
    }

    @Override
    public CompletableFuture<CancelTerminalRefundResponse> cancelTerminalRefundAsync(String terminalRefundId) {
        try {
            return this.prepareCancelTerminalRefundRequest(terminalRefundId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelTerminalRefundResponse, ApiException> prepareCancelTerminalRefundRequest(String terminalRefundId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/refunds/{terminal_refund_id}/cancel").templateParam(param -> param.key("terminal_refund_id").value((Object)terminalRefundId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelTerminalRefundResponse)ApiHelper.deserialize((String)response, CancelTerminalRefundResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DismissTerminalRefundResponse dismissTerminalRefund(String terminalRefundId) throws ApiException, IOException {
        return (DismissTerminalRefundResponse)this.prepareDismissTerminalRefundRequest(terminalRefundId).execute();
    }

    @Override
    public CompletableFuture<DismissTerminalRefundResponse> dismissTerminalRefundAsync(String terminalRefundId) {
        try {
            return this.prepareDismissTerminalRefundRequest(terminalRefundId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DismissTerminalRefundResponse, ApiException> prepareDismissTerminalRefundRequest(String terminalRefundId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/terminals/refunds/{terminal_refund_id}/dismiss").templateParam(param -> param.key("terminal_refund_id").value((Object)terminalRefundId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DismissTerminalRefundResponse)ApiHelper.deserialize((String)response, DismissTerminalRefundResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

