/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.square.models.Error;
import com.squareup.square.models.Payment;
import io.apimatic.core.types.CoreApiException;
import io.apimatic.core.utilities.CoreHelper;
import io.apimatic.coreinterfaces.http.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ApiException
extends CoreApiException {
    private static final long serialVersionUID = 1L;
    private Object data;
    private List<Error> errors;

    public ApiException(String reason) {
        super(reason);
    }

    public ApiException(String reason, Context context) {
        super(reason, context);
        try {
            JsonNode jsonNode = CoreHelper.getMapper().readTree(context.getResponse().getBody());
            if (jsonNode.hasNonNull("payment")) {
                this.data = CoreHelper.getMapper().convertValue((Object)jsonNode.get("payment"), Payment.class);
            }
            if (jsonNode.hasNonNull("errors")) {
                this.errors = Arrays.asList((Object[])CoreHelper.getMapper().convertValue((Object)jsonNode.get("errors"), Error[].class));
            } else {
                this.errors = new ArrayList<Error>();
                Error.Builder v1ErrorBuilder = new Error.Builder("V1_ERROR", jsonNode.hasNonNull("type") ? jsonNode.get("type").asText() : null);
                if (jsonNode.hasNonNull("message")) {
                    v1ErrorBuilder.detail(jsonNode.get("message").asText());
                }
                this.errors.add(v1ErrorBuilder.build());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }
}

