/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.http;

import io.apimatic.coreinterfaces.http.HttpHeaders;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Headers
implements HttpHeaders {
    private Map<String, List<String>> headers;

    public Headers() {
        this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    }

    public Headers(Map<String, List<String>> headers) {
        this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<String>> kv : headers.entrySet()) {
            this.add(kv.getKey(), kv.getValue());
        }
    }

    public Headers(Headers h) {
        this.headers = this.cloneHeaderMap(h.headers);
    }

    public boolean has(String headerName) {
        return this.headers.containsKey(headerName);
    }

    public Set<String> names() {
        return this.headers.keySet();
    }

    public String value(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return this.headers.get(headerName).get(0);
        }
        return null;
    }

    public List<String> values(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return this.headers.get(headerName);
        }
        return null;
    }

    public Map<String, String> asSimpleMap() {
        TreeMap<String, String> copy = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<String>> kv : this.headers.entrySet()) {
            if (kv.getValue() == null) continue;
            copy.put(kv.getKey(), kv.getValue().get(0));
        }
        return copy;
    }

    public Map<String, List<String>> asMultimap() {
        return this.cloneHeaderMap(this.headers);
    }

    private Map<String, List<String>> cloneHeaderMap(Map<String, List<String>> headerMap) {
        TreeMap<String, List<String>> copy = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<String>> kv : headerMap.entrySet()) {
            if (kv.getValue() == null) continue;
            copy.put(kv.getKey(), kv.getValue());
        }
        return copy;
    }

    public void add(String headerName, String value) {
        if (headerName == null || value == null) {
            return;
        }
        if (this.headers.containsKey(headerName)) {
            this.headers.get(headerName).add(value);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.headers.put(headerName, values);
        }
    }

    public void add(String headerName, List<String> values) {
        if (headerName == null || values == null) {
            return;
        }
        if (this.headers.containsKey(headerName)) {
            for (String value : values) {
                if (value == null) continue;
                this.headers.get(headerName).add(value);
            }
        } else {
            ArrayList<String> copyOfValues = new ArrayList<String>();
            for (String value : values) {
                if (value == null) continue;
                copyOfValues.add(value);
            }
            if (!copyOfValues.isEmpty()) {
                this.headers.put(headerName, copyOfValues);
            }
        }
    }

    public Headers createHeader(String headerName, String value) {
        this.add(headerName, value);
        return this;
    }

    public void addAllFromMap(Map<String, String> headers) {
        for (Map.Entry<String, String> kv : headers.entrySet()) {
            this.add(kv.getKey(), kv.getValue());
        }
    }

    public void addAllFromMultiMap(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> kv : headers.entrySet()) {
            this.add(kv.getKey(), kv.getValue());
        }
    }

    public void addAll(HttpHeaders headers) {
        for (Map.Entry kv : headers.asMultimap().entrySet()) {
            this.add((String)kv.getKey(), (List)kv.getValue());
        }
    }

    public List<String> remove(String headerName) {
        if (this.headers.containsKey(headerName)) {
            return this.headers.remove(headerName);
        }
        return null;
    }

    public String toString() {
        return "Headers " + this.headers;
    }
}

