/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.http.client;

import com.squareup.square.http.client.ReadonlyHttpClientConfiguration;
import com.squareup.square.http.request.HttpMethod;
import io.apimatic.core.configurations.http.client.CoreHttpClientConfiguration;
import io.apimatic.coreinterfaces.http.ClientConfiguration;
import io.apimatic.coreinterfaces.http.HttpMethodType;
import io.apimatic.coreinterfaces.http.Method;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;

public class HttpClientConfiguration
implements ReadonlyHttpClientConfiguration {
    private final ClientConfiguration configuration;

    private HttpClientConfiguration(CoreHttpClientConfiguration.Builder configurationBuilder) {
        this.configuration = configurationBuilder.build();
    }

    @Override
    public long getTimeout() {
        return this.configuration.getTimeout();
    }

    @Override
    public int getNumberOfRetries() {
        return this.configuration.getNumberOfRetries();
    }

    @Override
    public int getBackOffFactor() {
        return this.configuration.getBackOffFactor();
    }

    @Override
    public long getRetryInterval() {
        return this.configuration.getRetryInterval();
    }

    @Override
    public Set<Integer> getHttpStatusCodesToRetry() {
        return this.configuration.getHttpStatusCodesToRetry();
    }

    @Override
    public Set<HttpMethod> getHttpMethodsToRetry() {
        if (this.configuration.getHttpMethodsToRetry() == null) {
            return null;
        }
        return this.configuration.getHttpMethodsToRetry().stream().map(httpMethod -> HttpMethod.valueOf(httpMethod.toString())).collect(Collectors.toSet());
    }

    @Override
    public long getMaximumRetryWaitTime() {
        return this.configuration.getMaximumRetryWaitTime();
    }

    @Override
    public boolean shouldRetryOnTimeout() {
        return this.configuration.shouldRetryOnTimeout();
    }

    @Override
    public OkHttpClient getHttpClientInstance() {
        return this.configuration.getHttpClientInstance();
    }

    @Override
    public boolean shouldOverrideHttpClientConfigurations() {
        return this.configuration.shouldOverrideHttpClientConfigurations();
    }

    public ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "HttpClientConfiguration [timeout=" + this.getTimeout() + ", numberOfRetries=" + this.getNumberOfRetries() + ", backOffFactor=" + this.getBackOffFactor() + ", retryInterval=" + this.getRetryInterval() + ", httpStatusCodesToRetry=" + this.getHttpStatusCodesToRetry() + ", httpMethodsToRetry=" + this.getHttpMethodsToRetry() + ", maximumRetryWaitTime=" + this.getMaximumRetryWaitTime() + ", shouldRetryOnTimeout=" + this.shouldRetryOnTimeout() + ", httpClientInstance=" + this.getHttpClientInstance() + ", overrideHttpClientConfigurations=" + this.shouldOverrideHttpClientConfigurations() + "]";
    }

    public Builder newBuilder() {
        return new Builder().timeout(this.getTimeout()).numberOfRetries(this.getNumberOfRetries()).backOffFactor(this.getBackOffFactor()).retryInterval(this.getRetryInterval()).httpStatusCodesToRetry(this.getHttpStatusCodesToRetry()).httpMethodsToRetry(this.getHttpMethodsToRetry()).maximumRetryWaitTime(this.getMaximumRetryWaitTime()).shouldRetryOnTimeout(this.shouldRetryOnTimeout()).httpClientInstance(this.getHttpClientInstance(), this.shouldOverrideHttpClientConfigurations());
    }

    public static class Builder {
        private final CoreHttpClientConfiguration.Builder configurationBuilder = new CoreHttpClientConfiguration.Builder();

        public Builder() {
            this.configurationBuilder.httpStatusCodesToRetry(Stream.of(408, 413, 429, 500, 502, 503, 504, 521, 522, 524).collect(Collectors.toSet()));
            this.configurationBuilder.httpMethodsToRetry(Stream.of(Method.GET, Method.PUT).collect(Collectors.toSet()));
        }

        public Builder timeout(long timeout) {
            this.configurationBuilder.timeout(timeout);
            return this;
        }

        public Builder numberOfRetries(int numberOfRetries) {
            this.configurationBuilder.numberOfRetries(numberOfRetries);
            return this;
        }

        public Builder backOffFactor(int backOffFactor) {
            this.configurationBuilder.backOffFactor(backOffFactor);
            return this;
        }

        public Builder retryInterval(long retryInterval) {
            this.configurationBuilder.retryInterval(retryInterval);
            return this;
        }

        public Builder httpStatusCodesToRetry(Set<Integer> httpStatusCodesToRetry) {
            this.configurationBuilder.httpStatusCodesToRetry(httpStatusCodesToRetry);
            return this;
        }

        public Builder httpMethodsToRetry(Set<HttpMethod> httpMethodsToRetry) {
            Set convertedHttpMethodsToRetry = null;
            if (httpMethodsToRetry != null) {
                convertedHttpMethodsToRetry = httpMethodsToRetry.stream().map(httpMethod -> HttpMethodType.valueOf((String)httpMethod.toString())).collect(Collectors.toSet());
            }
            this.configurationBuilder.httpMethodsToRetry(convertedHttpMethodsToRetry);
            return this;
        }

        public Builder maximumRetryWaitTime(long maximumRetryWaitTime) {
            this.configurationBuilder.maximumRetryWaitTime(maximumRetryWaitTime);
            return this;
        }

        public Builder shouldRetryOnTimeout(boolean shouldRetryOnTimeout) {
            this.configurationBuilder.shouldRetryOnTimeout(shouldRetryOnTimeout);
            return this;
        }

        public Builder httpClientInstance(OkHttpClient httpClientInstance) {
            this.configurationBuilder.httpClientInstance(httpClientInstance);
            return this;
        }

        public Builder httpClientInstance(OkHttpClient httpClientInstance, boolean overrideHttpClientConfigurations) {
            this.configurationBuilder.httpClientInstance(httpClientInstance, overrideHttpClientConfigurations);
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this.configurationBuilder);
        }
    }
}

