/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ACHDetails {
    private final OptionalNullable<String> routingNumber;
    private final OptionalNullable<String> accountNumberSuffix;
    private final OptionalNullable<String> accountType;

    @JsonCreator
    public ACHDetails(@JsonProperty(value="routing_number") String routingNumber, @JsonProperty(value="account_number_suffix") String accountNumberSuffix, @JsonProperty(value="account_type") String accountType) {
        this.routingNumber = OptionalNullable.of((Object)routingNumber);
        this.accountNumberSuffix = OptionalNullable.of((Object)accountNumberSuffix);
        this.accountType = OptionalNullable.of((Object)accountType);
    }

    protected ACHDetails(OptionalNullable<String> routingNumber, OptionalNullable<String> accountNumberSuffix, OptionalNullable<String> accountType) {
        this.routingNumber = routingNumber;
        this.accountNumberSuffix = accountNumberSuffix;
        this.accountType = accountType;
    }

    @JsonGetter(value="routing_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetRoutingNumber() {
        return this.routingNumber;
    }

    @JsonIgnore
    public String getRoutingNumber() {
        return (String)OptionalNullable.getFrom(this.routingNumber);
    }

    @JsonGetter(value="account_number_suffix")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    @JsonIgnore
    public String getAccountNumberSuffix() {
        return (String)OptionalNullable.getFrom(this.accountNumberSuffix);
    }

    @JsonGetter(value="account_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAccountType() {
        return this.accountType;
    }

    @JsonIgnore
    public String getAccountType() {
        return (String)OptionalNullable.getFrom(this.accountType);
    }

    public int hashCode() {
        return Objects.hash(this.routingNumber, this.accountNumberSuffix, this.accountType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ACHDetails)) {
            return false;
        }
        ACHDetails other = (ACHDetails)obj;
        return Objects.equals(this.routingNumber, other.routingNumber) && Objects.equals(this.accountNumberSuffix, other.accountNumberSuffix) && Objects.equals(this.accountType, other.accountType);
    }

    public String toString() {
        return "ACHDetails [routingNumber=" + this.routingNumber + ", accountNumberSuffix=" + this.accountNumberSuffix + ", accountType=" + this.accountType + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.routingNumber = this.internalGetRoutingNumber();
        builder.accountNumberSuffix = this.internalGetAccountNumberSuffix();
        builder.accountType = this.internalGetAccountType();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> routingNumber;
        private OptionalNullable<String> accountNumberSuffix;
        private OptionalNullable<String> accountType;

        public Builder routingNumber(String routingNumber) {
            this.routingNumber = OptionalNullable.of((Object)routingNumber);
            return this;
        }

        public Builder unsetRoutingNumber() {
            this.routingNumber = null;
            return this;
        }

        public Builder accountNumberSuffix(String accountNumberSuffix) {
            this.accountNumberSuffix = OptionalNullable.of((Object)accountNumberSuffix);
            return this;
        }

        public Builder unsetAccountNumberSuffix() {
            this.accountNumberSuffix = null;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = OptionalNullable.of((Object)accountType);
            return this;
        }

        public Builder unsetAccountType() {
            this.accountType = null;
            return this;
        }

        public ACHDetails build() {
            return new ACHDetails(this.routingNumber, this.accountNumberSuffix, this.accountType);
        }
    }
}

