/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Dispute;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class AcceptDisputeResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Dispute dispute;

    @JsonCreator
    public AcceptDisputeResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="dispute") Dispute dispute) {
        this.errors = errors;
        this.dispute = dispute;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="dispute")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Dispute getDispute() {
        return this.dispute;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.dispute);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AcceptDisputeResponse)) {
            return false;
        }
        AcceptDisputeResponse other = (AcceptDisputeResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.dispute, other.dispute);
    }

    public String toString() {
        return "AcceptDisputeResponse [errors=" + this.errors + ", dispute=" + this.dispute + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).dispute(this.getDispute());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Dispute dispute;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder dispute(Dispute dispute) {
            this.dispute = dispute;
            return this;
        }

        public AcceptDisputeResponse build() {
            AcceptDisputeResponse model = new AcceptDisputeResponse(this.errors, this.dispute);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

