/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.LoyaltyEventAdjustPoints;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class AdjustLoyaltyPointsRequest {
    private final String idempotencyKey;
    private final LoyaltyEventAdjustPoints adjustPoints;
    private final OptionalNullable<Boolean> allowNegativeBalance;

    @JsonCreator
    public AdjustLoyaltyPointsRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="adjust_points") LoyaltyEventAdjustPoints adjustPoints, @JsonProperty(value="allow_negative_balance") Boolean allowNegativeBalance) {
        this.idempotencyKey = idempotencyKey;
        this.adjustPoints = adjustPoints;
        this.allowNegativeBalance = OptionalNullable.of((Object)allowNegativeBalance);
    }

    protected AdjustLoyaltyPointsRequest(String idempotencyKey, LoyaltyEventAdjustPoints adjustPoints, OptionalNullable<Boolean> allowNegativeBalance) {
        this.idempotencyKey = idempotencyKey;
        this.adjustPoints = adjustPoints;
        this.allowNegativeBalance = allowNegativeBalance;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="adjust_points")
    public LoyaltyEventAdjustPoints getAdjustPoints() {
        return this.adjustPoints;
    }

    @JsonGetter(value="allow_negative_balance")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAllowNegativeBalance() {
        return this.allowNegativeBalance;
    }

    @JsonIgnore
    public Boolean getAllowNegativeBalance() {
        return (Boolean)OptionalNullable.getFrom(this.allowNegativeBalance);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.adjustPoints, this.allowNegativeBalance);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdjustLoyaltyPointsRequest)) {
            return false;
        }
        AdjustLoyaltyPointsRequest other = (AdjustLoyaltyPointsRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.adjustPoints, other.adjustPoints) && Objects.equals(this.allowNegativeBalance, other.allowNegativeBalance);
    }

    public String toString() {
        return "AdjustLoyaltyPointsRequest [idempotencyKey=" + this.idempotencyKey + ", adjustPoints=" + this.adjustPoints + ", allowNegativeBalance=" + this.allowNegativeBalance + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.adjustPoints);
        builder.allowNegativeBalance = this.internalGetAllowNegativeBalance();
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private LoyaltyEventAdjustPoints adjustPoints;
        private OptionalNullable<Boolean> allowNegativeBalance;

        public Builder(String idempotencyKey, LoyaltyEventAdjustPoints adjustPoints) {
            this.idempotencyKey = idempotencyKey;
            this.adjustPoints = adjustPoints;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder adjustPoints(LoyaltyEventAdjustPoints adjustPoints) {
            this.adjustPoints = adjustPoints;
            return this;
        }

        public Builder allowNegativeBalance(Boolean allowNegativeBalance) {
            this.allowNegativeBalance = OptionalNullable.of((Object)allowNegativeBalance);
            return this;
        }

        public Builder unsetAllowNegativeBalance() {
            this.allowNegativeBalance = null;
            return this;
        }

        public AdjustLoyaltyPointsRequest build() {
            return new AdjustLoyaltyPointsRequest(this.idempotencyKey, this.adjustPoints, this.allowNegativeBalance);
        }
    }
}

