/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class AfterpayDetails {
    private final OptionalNullable<String> emailAddress;

    @JsonCreator
    public AfterpayDetails(@JsonProperty(value="email_address") String emailAddress) {
        this.emailAddress = OptionalNullable.of((Object)emailAddress);
    }

    protected AfterpayDetails(OptionalNullable<String> emailAddress) {
        this.emailAddress = emailAddress;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public String getEmailAddress() {
        return (String)OptionalNullable.getFrom(this.emailAddress);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AfterpayDetails)) {
            return false;
        }
        AfterpayDetails other = (AfterpayDetails)obj;
        return Objects.equals(this.emailAddress, other.emailAddress);
    }

    public String toString() {
        return "AfterpayDetails [emailAddress=" + this.emailAddress + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.emailAddress = this.internalGetEmailAddress();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> emailAddress;

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = OptionalNullable.of((Object)emailAddress);
            return this;
        }

        public Builder unsetEmailAddress() {
            this.emailAddress = null;
            return this;
        }

        public AfterpayDetails build() {
            return new AfterpayDetails(this.emailAddress);
        }
    }
}

