/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.AppointmentSegment;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Availability {
    private final OptionalNullable<String> startAt;
    private final String locationId;
    private final OptionalNullable<List<AppointmentSegment>> appointmentSegments;

    @JsonCreator
    public Availability(@JsonProperty(value="start_at") String startAt, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="appointment_segments") List<AppointmentSegment> appointmentSegments) {
        this.startAt = OptionalNullable.of((Object)startAt);
        this.locationId = locationId;
        this.appointmentSegments = OptionalNullable.of(appointmentSegments);
    }

    protected Availability(OptionalNullable<String> startAt, String locationId, OptionalNullable<List<AppointmentSegment>> appointmentSegments) {
        this.startAt = startAt;
        this.locationId = locationId;
        this.appointmentSegments = appointmentSegments;
    }

    @JsonGetter(value="start_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStartAt() {
        return this.startAt;
    }

    @JsonIgnore
    public String getStartAt() {
        return (String)OptionalNullable.getFrom(this.startAt);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="appointment_segments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<AppointmentSegment>> internalGetAppointmentSegments() {
        return this.appointmentSegments;
    }

    @JsonIgnore
    public List<AppointmentSegment> getAppointmentSegments() {
        return (List)OptionalNullable.getFrom(this.appointmentSegments);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.locationId, this.appointmentSegments);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Availability)) {
            return false;
        }
        Availability other = (Availability)obj;
        return Objects.equals(this.startAt, other.startAt) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.appointmentSegments, other.appointmentSegments);
    }

    public String toString() {
        return "Availability [startAt=" + this.startAt + ", locationId=" + this.locationId + ", appointmentSegments=" + this.appointmentSegments + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationId(this.getLocationId());
        builder.startAt = this.internalGetStartAt();
        builder.appointmentSegments = this.internalGetAppointmentSegments();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> startAt;
        private String locationId;
        private OptionalNullable<List<AppointmentSegment>> appointmentSegments;

        public Builder startAt(String startAt) {
            this.startAt = OptionalNullable.of((Object)startAt);
            return this;
        }

        public Builder unsetStartAt() {
            this.startAt = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder appointmentSegments(List<AppointmentSegment> appointmentSegments) {
            this.appointmentSegments = OptionalNullable.of(appointmentSegments);
            return this;
        }

        public Builder unsetAppointmentSegments() {
            this.appointmentSegments = null;
            return this;
        }

        public Availability build() {
            return new Availability(this.startAt, this.locationId, this.appointmentSegments);
        }
    }
}

