/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BankAccount {
    private final String id;
    private final String accountNumberSuffix;
    private final String country;
    private final String currency;
    private final String accountType;
    private final String holderName;
    private final String primaryBankIdentificationNumber;
    private final OptionalNullable<String> secondaryBankIdentificationNumber;
    private final OptionalNullable<String> debitMandateReferenceId;
    private final OptionalNullable<String> referenceId;
    private final OptionalNullable<String> locationId;
    private final String status;
    private final boolean creditable;
    private final boolean debitable;
    private final OptionalNullable<String> fingerprint;
    private final Integer version;
    private final OptionalNullable<String> bankName;

    @JsonCreator
    public BankAccount(@JsonProperty(value="id") String id, @JsonProperty(value="account_number_suffix") String accountNumberSuffix, @JsonProperty(value="country") String country, @JsonProperty(value="currency") String currency, @JsonProperty(value="account_type") String accountType, @JsonProperty(value="holder_name") String holderName, @JsonProperty(value="primary_bank_identification_number") String primaryBankIdentificationNumber, @JsonProperty(value="status") String status, @JsonProperty(value="creditable") boolean creditable, @JsonProperty(value="debitable") boolean debitable, @JsonProperty(value="secondary_bank_identification_number") String secondaryBankIdentificationNumber, @JsonProperty(value="debit_mandate_reference_id") String debitMandateReferenceId, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="fingerprint") String fingerprint, @JsonProperty(value="version") Integer version, @JsonProperty(value="bank_name") String bankName) {
        this.id = id;
        this.accountNumberSuffix = accountNumberSuffix;
        this.country = country;
        this.currency = currency;
        this.accountType = accountType;
        this.holderName = holderName;
        this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
        this.secondaryBankIdentificationNumber = OptionalNullable.of((Object)secondaryBankIdentificationNumber);
        this.debitMandateReferenceId = OptionalNullable.of((Object)debitMandateReferenceId);
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.locationId = OptionalNullable.of((Object)locationId);
        this.status = status;
        this.creditable = creditable;
        this.debitable = debitable;
        this.fingerprint = OptionalNullable.of((Object)fingerprint);
        this.version = version;
        this.bankName = OptionalNullable.of((Object)bankName);
    }

    protected BankAccount(String id, String accountNumberSuffix, String country, String currency, String accountType, String holderName, String primaryBankIdentificationNumber, String status, boolean creditable, boolean debitable, OptionalNullable<String> secondaryBankIdentificationNumber, OptionalNullable<String> debitMandateReferenceId, OptionalNullable<String> referenceId, OptionalNullable<String> locationId, OptionalNullable<String> fingerprint, Integer version, OptionalNullable<String> bankName) {
        this.id = id;
        this.accountNumberSuffix = accountNumberSuffix;
        this.country = country;
        this.currency = currency;
        this.accountType = accountType;
        this.holderName = holderName;
        this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
        this.secondaryBankIdentificationNumber = secondaryBankIdentificationNumber;
        this.debitMandateReferenceId = debitMandateReferenceId;
        this.referenceId = referenceId;
        this.locationId = locationId;
        this.status = status;
        this.creditable = creditable;
        this.debitable = debitable;
        this.fingerprint = fingerprint;
        this.version = version;
        this.bankName = bankName;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="account_number_suffix")
    public String getAccountNumberSuffix() {
        return this.accountNumberSuffix;
    }

    @JsonGetter(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonGetter(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonGetter(value="account_type")
    public String getAccountType() {
        return this.accountType;
    }

    @JsonGetter(value="holder_name")
    public String getHolderName() {
        return this.holderName;
    }

    @JsonGetter(value="primary_bank_identification_number")
    public String getPrimaryBankIdentificationNumber() {
        return this.primaryBankIdentificationNumber;
    }

    @JsonGetter(value="secondary_bank_identification_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSecondaryBankIdentificationNumber() {
        return this.secondaryBankIdentificationNumber;
    }

    @JsonIgnore
    public String getSecondaryBankIdentificationNumber() {
        return (String)OptionalNullable.getFrom(this.secondaryBankIdentificationNumber);
    }

    @JsonGetter(value="debit_mandate_reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDebitMandateReferenceId() {
        return this.debitMandateReferenceId;
    }

    @JsonIgnore
    public String getDebitMandateReferenceId() {
        return (String)OptionalNullable.getFrom(this.debitMandateReferenceId);
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="creditable")
    public boolean getCreditable() {
        return this.creditable;
    }

    @JsonGetter(value="debitable")
    public boolean getDebitable() {
        return this.debitable;
    }

    @JsonGetter(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFingerprint() {
        return this.fingerprint;
    }

    @JsonIgnore
    public String getFingerprint() {
        return (String)OptionalNullable.getFrom(this.fingerprint);
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="bank_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBankName() {
        return this.bankName;
    }

    @JsonIgnore
    public String getBankName() {
        return (String)OptionalNullable.getFrom(this.bankName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.secondaryBankIdentificationNumber, this.debitMandateReferenceId, this.referenceId, this.locationId, this.status, this.creditable, this.debitable, this.fingerprint, this.version, this.bankName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BankAccount)) {
            return false;
        }
        BankAccount other = (BankAccount)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.accountNumberSuffix, other.accountNumberSuffix) && Objects.equals(this.country, other.country) && Objects.equals(this.currency, other.currency) && Objects.equals(this.accountType, other.accountType) && Objects.equals(this.holderName, other.holderName) && Objects.equals(this.primaryBankIdentificationNumber, other.primaryBankIdentificationNumber) && Objects.equals(this.secondaryBankIdentificationNumber, other.secondaryBankIdentificationNumber) && Objects.equals(this.debitMandateReferenceId, other.debitMandateReferenceId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.status, other.status) && Objects.equals(this.creditable, other.creditable) && Objects.equals(this.debitable, other.debitable) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.version, other.version) && Objects.equals(this.bankName, other.bankName);
    }

    public String toString() {
        return "BankAccount [id=" + this.id + ", accountNumberSuffix=" + this.accountNumberSuffix + ", country=" + this.country + ", currency=" + this.currency + ", accountType=" + this.accountType + ", holderName=" + this.holderName + ", primaryBankIdentificationNumber=" + this.primaryBankIdentificationNumber + ", status=" + this.status + ", creditable=" + this.creditable + ", debitable=" + this.debitable + ", secondaryBankIdentificationNumber=" + this.secondaryBankIdentificationNumber + ", debitMandateReferenceId=" + this.debitMandateReferenceId + ", referenceId=" + this.referenceId + ", locationId=" + this.locationId + ", fingerprint=" + this.fingerprint + ", version=" + this.version + ", bankName=" + this.bankName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.status, this.creditable, this.debitable).version(this.getVersion());
        builder.secondaryBankIdentificationNumber = this.internalGetSecondaryBankIdentificationNumber();
        builder.debitMandateReferenceId = this.internalGetDebitMandateReferenceId();
        builder.referenceId = this.internalGetReferenceId();
        builder.locationId = this.internalGetLocationId();
        builder.fingerprint = this.internalGetFingerprint();
        builder.bankName = this.internalGetBankName();
        return builder;
    }

    public static class Builder {
        private String id;
        private String accountNumberSuffix;
        private String country;
        private String currency;
        private String accountType;
        private String holderName;
        private String primaryBankIdentificationNumber;
        private String status;
        private boolean creditable;
        private boolean debitable;
        private OptionalNullable<String> secondaryBankIdentificationNumber;
        private OptionalNullable<String> debitMandateReferenceId;
        private OptionalNullable<String> referenceId;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> fingerprint;
        private Integer version;
        private OptionalNullable<String> bankName;

        public Builder(String id, String accountNumberSuffix, String country, String currency, String accountType, String holderName, String primaryBankIdentificationNumber, String status, boolean creditable, boolean debitable) {
            this.id = id;
            this.accountNumberSuffix = accountNumberSuffix;
            this.country = country;
            this.currency = currency;
            this.accountType = accountType;
            this.holderName = holderName;
            this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
            this.status = status;
            this.creditable = creditable;
            this.debitable = debitable;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder accountNumberSuffix(String accountNumberSuffix) {
            this.accountNumberSuffix = accountNumberSuffix;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        public Builder holderName(String holderName) {
            this.holderName = holderName;
            return this;
        }

        public Builder primaryBankIdentificationNumber(String primaryBankIdentificationNumber) {
            this.primaryBankIdentificationNumber = primaryBankIdentificationNumber;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder creditable(boolean creditable) {
            this.creditable = creditable;
            return this;
        }

        public Builder debitable(boolean debitable) {
            this.debitable = debitable;
            return this;
        }

        public Builder secondaryBankIdentificationNumber(String secondaryBankIdentificationNumber) {
            this.secondaryBankIdentificationNumber = OptionalNullable.of((Object)secondaryBankIdentificationNumber);
            return this;
        }

        public Builder unsetSecondaryBankIdentificationNumber() {
            this.secondaryBankIdentificationNumber = null;
            return this;
        }

        public Builder debitMandateReferenceId(String debitMandateReferenceId) {
            this.debitMandateReferenceId = OptionalNullable.of((Object)debitMandateReferenceId);
            return this;
        }

        public Builder unsetDebitMandateReferenceId() {
            this.debitMandateReferenceId = null;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = OptionalNullable.of((Object)fingerprint);
            return this;
        }

        public Builder unsetFingerprint() {
            this.fingerprint = null;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = OptionalNullable.of((Object)bankName);
            return this;
        }

        public Builder unsetBankName() {
            this.bankName = null;
            return this;
        }

        public BankAccount build() {
            return new BankAccount(this.id, this.accountNumberSuffix, this.country, this.currency, this.accountType, this.holderName, this.primaryBankIdentificationNumber, this.status, this.creditable, this.debitable, this.secondaryBankIdentificationNumber, this.debitMandateReferenceId, this.referenceId, this.locationId, this.fingerprint, this.version, this.bankName);
        }
    }
}

