/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.InventoryChange;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BatchChangeInventoryRequest {
    private final String idempotencyKey;
    private final OptionalNullable<List<InventoryChange>> changes;
    private final OptionalNullable<Boolean> ignoreUnchangedCounts;

    @JsonCreator
    public BatchChangeInventoryRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="changes") List<InventoryChange> changes, @JsonProperty(value="ignore_unchanged_counts") Boolean ignoreUnchangedCounts) {
        this.idempotencyKey = idempotencyKey;
        this.changes = OptionalNullable.of(changes);
        this.ignoreUnchangedCounts = OptionalNullable.of((Object)ignoreUnchangedCounts);
    }

    protected BatchChangeInventoryRequest(String idempotencyKey, OptionalNullable<List<InventoryChange>> changes, OptionalNullable<Boolean> ignoreUnchangedCounts) {
        this.idempotencyKey = idempotencyKey;
        this.changes = changes;
        this.ignoreUnchangedCounts = ignoreUnchangedCounts;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="changes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<InventoryChange>> internalGetChanges() {
        return this.changes;
    }

    @JsonIgnore
    public List<InventoryChange> getChanges() {
        return (List)OptionalNullable.getFrom(this.changes);
    }

    @JsonGetter(value="ignore_unchanged_counts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIgnoreUnchangedCounts() {
        return this.ignoreUnchangedCounts;
    }

    @JsonIgnore
    public Boolean getIgnoreUnchangedCounts() {
        return (Boolean)OptionalNullable.getFrom(this.ignoreUnchangedCounts);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.changes, this.ignoreUnchangedCounts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchChangeInventoryRequest)) {
            return false;
        }
        BatchChangeInventoryRequest other = (BatchChangeInventoryRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.changes, other.changes) && Objects.equals(this.ignoreUnchangedCounts, other.ignoreUnchangedCounts);
    }

    public String toString() {
        return "BatchChangeInventoryRequest [idempotencyKey=" + this.idempotencyKey + ", changes=" + this.changes + ", ignoreUnchangedCounts=" + this.ignoreUnchangedCounts + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey);
        builder.changes = this.internalGetChanges();
        builder.ignoreUnchangedCounts = this.internalGetIgnoreUnchangedCounts();
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private OptionalNullable<List<InventoryChange>> changes;
        private OptionalNullable<Boolean> ignoreUnchangedCounts;

        public Builder(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder changes(List<InventoryChange> changes) {
            this.changes = OptionalNullable.of(changes);
            return this;
        }

        public Builder unsetChanges() {
            this.changes = null;
            return this;
        }

        public Builder ignoreUnchangedCounts(Boolean ignoreUnchangedCounts) {
            this.ignoreUnchangedCounts = OptionalNullable.of((Object)ignoreUnchangedCounts);
            return this;
        }

        public Builder unsetIgnoreUnchangedCounts() {
            this.ignoreUnchangedCounts = null;
            return this;
        }

        public BatchChangeInventoryRequest build() {
            return new BatchChangeInventoryRequest(this.idempotencyKey, this.changes, this.ignoreUnchangedCounts);
        }
    }
}

