/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveCatalogObjectsRequest {
    private final List<String> objectIds;
    private final OptionalNullable<Boolean> includeRelatedObjects;
    private final OptionalNullable<Long> catalogVersion;
    private final OptionalNullable<Boolean> includeDeletedObjects;
    private final OptionalNullable<Boolean> includeCategoryPathToRoot;

    @JsonCreator
    public BatchRetrieveCatalogObjectsRequest(@JsonProperty(value="object_ids") List<String> objectIds, @JsonProperty(value="include_related_objects") Boolean includeRelatedObjects, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="include_deleted_objects") Boolean includeDeletedObjects, @JsonProperty(value="include_category_path_to_root") Boolean includeCategoryPathToRoot) {
        this.objectIds = objectIds;
        this.includeRelatedObjects = OptionalNullable.of((Object)includeRelatedObjects);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
        this.includeDeletedObjects = OptionalNullable.of((Object)includeDeletedObjects);
        this.includeCategoryPathToRoot = OptionalNullable.of((Object)includeCategoryPathToRoot);
    }

    protected BatchRetrieveCatalogObjectsRequest(List<String> objectIds, OptionalNullable<Boolean> includeRelatedObjects, OptionalNullable<Long> catalogVersion, OptionalNullable<Boolean> includeDeletedObjects, OptionalNullable<Boolean> includeCategoryPathToRoot) {
        this.objectIds = objectIds;
        this.includeRelatedObjects = includeRelatedObjects;
        this.catalogVersion = catalogVersion;
        this.includeDeletedObjects = includeDeletedObjects;
        this.includeCategoryPathToRoot = includeCategoryPathToRoot;
    }

    @JsonGetter(value="object_ids")
    public List<String> getObjectIds() {
        return this.objectIds;
    }

    @JsonGetter(value="include_related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonIgnore
    public Boolean getIncludeRelatedObjects() {
        return (Boolean)OptionalNullable.getFrom(this.includeRelatedObjects);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    @JsonGetter(value="include_deleted_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    @JsonIgnore
    public Boolean getIncludeDeletedObjects() {
        return (Boolean)OptionalNullable.getFrom(this.includeDeletedObjects);
    }

    @JsonGetter(value="include_category_path_to_root")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeCategoryPathToRoot() {
        return this.includeCategoryPathToRoot;
    }

    @JsonIgnore
    public Boolean getIncludeCategoryPathToRoot() {
        return (Boolean)OptionalNullable.getFrom(this.includeCategoryPathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.objectIds, this.includeRelatedObjects, this.catalogVersion, this.includeDeletedObjects, this.includeCategoryPathToRoot);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveCatalogObjectsRequest)) {
            return false;
        }
        BatchRetrieveCatalogObjectsRequest other = (BatchRetrieveCatalogObjectsRequest)obj;
        return Objects.equals(this.objectIds, other.objectIds) && Objects.equals(this.includeRelatedObjects, other.includeRelatedObjects) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.includeDeletedObjects, other.includeDeletedObjects) && Objects.equals(this.includeCategoryPathToRoot, other.includeCategoryPathToRoot);
    }

    public String toString() {
        return "BatchRetrieveCatalogObjectsRequest [objectIds=" + this.objectIds + ", includeRelatedObjects=" + this.includeRelatedObjects + ", catalogVersion=" + this.catalogVersion + ", includeDeletedObjects=" + this.includeDeletedObjects + ", includeCategoryPathToRoot=" + this.includeCategoryPathToRoot + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.objectIds);
        builder.includeRelatedObjects = this.internalGetIncludeRelatedObjects();
        builder.catalogVersion = this.internalGetCatalogVersion();
        builder.includeDeletedObjects = this.internalGetIncludeDeletedObjects();
        builder.includeCategoryPathToRoot = this.internalGetIncludeCategoryPathToRoot();
        return builder;
    }

    public static class Builder {
        private List<String> objectIds;
        private OptionalNullable<Boolean> includeRelatedObjects;
        private OptionalNullable<Long> catalogVersion;
        private OptionalNullable<Boolean> includeDeletedObjects;
        private OptionalNullable<Boolean> includeCategoryPathToRoot;

        public Builder(List<String> objectIds) {
            this.objectIds = objectIds;
        }

        public Builder objectIds(List<String> objectIds) {
            this.objectIds = objectIds;
            return this;
        }

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = OptionalNullable.of((Object)includeRelatedObjects);
            return this;
        }

        public Builder unsetIncludeRelatedObjects() {
            this.includeRelatedObjects = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public Builder includeDeletedObjects(Boolean includeDeletedObjects) {
            this.includeDeletedObjects = OptionalNullable.of((Object)includeDeletedObjects);
            return this;
        }

        public Builder unsetIncludeDeletedObjects() {
            this.includeDeletedObjects = null;
            return this;
        }

        public Builder includeCategoryPathToRoot(Boolean includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = OptionalNullable.of((Object)includeCategoryPathToRoot);
            return this;
        }

        public Builder unsetIncludeCategoryPathToRoot() {
            this.includeCategoryPathToRoot = null;
            return this;
        }

        public BatchRetrieveCatalogObjectsRequest build() {
            return new BatchRetrieveCatalogObjectsRequest(this.objectIds, this.includeRelatedObjects, this.catalogVersion, this.includeDeletedObjects, this.includeCategoryPathToRoot);
        }
    }
}

