/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveInventoryChangesRequest {
    private final OptionalNullable<List<String>> catalogObjectIds;
    private final OptionalNullable<List<String>> locationIds;
    private final OptionalNullable<List<String>> types;
    private final OptionalNullable<List<String>> states;
    private final OptionalNullable<String> updatedAfter;
    private final OptionalNullable<String> updatedBefore;
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Integer> limit;

    @JsonCreator
    public BatchRetrieveInventoryChangesRequest(@JsonProperty(value="catalog_object_ids") List<String> catalogObjectIds, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="types") List<String> types, @JsonProperty(value="states") List<String> states, @JsonProperty(value="updated_after") String updatedAfter, @JsonProperty(value="updated_before") String updatedBefore, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit) {
        this.catalogObjectIds = OptionalNullable.of(catalogObjectIds);
        this.locationIds = OptionalNullable.of(locationIds);
        this.types = OptionalNullable.of(types);
        this.states = OptionalNullable.of(states);
        this.updatedAfter = OptionalNullable.of((Object)updatedAfter);
        this.updatedBefore = OptionalNullable.of((Object)updatedBefore);
        this.cursor = OptionalNullable.of((Object)cursor);
        this.limit = OptionalNullable.of((Object)limit);
    }

    protected BatchRetrieveInventoryChangesRequest(OptionalNullable<List<String>> catalogObjectIds, OptionalNullable<List<String>> locationIds, OptionalNullable<List<String>> types, OptionalNullable<List<String>> states, OptionalNullable<String> updatedAfter, OptionalNullable<String> updatedBefore, OptionalNullable<String> cursor, OptionalNullable<Integer> limit) {
        this.catalogObjectIds = catalogObjectIds;
        this.locationIds = locationIds;
        this.types = types;
        this.states = states;
        this.updatedAfter = updatedAfter;
        this.updatedBefore = updatedBefore;
        this.cursor = cursor;
        this.limit = limit;
    }

    @JsonGetter(value="catalog_object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    @JsonIgnore
    public List<String> getCatalogObjectIds() {
        return (List)OptionalNullable.getFrom(this.catalogObjectIds);
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetTypes() {
        return this.types;
    }

    @JsonIgnore
    public List<String> getTypes() {
        return (List)OptionalNullable.getFrom(this.types);
    }

    @JsonGetter(value="states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetStates() {
        return this.states;
    }

    @JsonIgnore
    public List<String> getStates() {
        return (List)OptionalNullable.getFrom(this.states);
    }

    @JsonGetter(value="updated_after")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUpdatedAfter() {
        return this.updatedAfter;
    }

    @JsonIgnore
    public String getUpdatedAfter() {
        return (String)OptionalNullable.getFrom(this.updatedAfter);
    }

    @JsonGetter(value="updated_before")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUpdatedBefore() {
        return this.updatedBefore;
    }

    @JsonIgnore
    public String getUpdatedBefore() {
        return (String)OptionalNullable.getFrom(this.updatedBefore);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectIds, this.locationIds, this.types, this.states, this.updatedAfter, this.updatedBefore, this.cursor, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveInventoryChangesRequest)) {
            return false;
        }
        BatchRetrieveInventoryChangesRequest other = (BatchRetrieveInventoryChangesRequest)obj;
        return Objects.equals(this.catalogObjectIds, other.catalogObjectIds) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.types, other.types) && Objects.equals(this.states, other.states) && Objects.equals(this.updatedAfter, other.updatedAfter) && Objects.equals(this.updatedBefore, other.updatedBefore) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "BatchRetrieveInventoryChangesRequest [catalogObjectIds=" + this.catalogObjectIds + ", locationIds=" + this.locationIds + ", types=" + this.types + ", states=" + this.states + ", updatedAfter=" + this.updatedAfter + ", updatedBefore=" + this.updatedBefore + ", cursor=" + this.cursor + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.catalogObjectIds = this.internalGetCatalogObjectIds();
        builder.locationIds = this.internalGetLocationIds();
        builder.types = this.internalGetTypes();
        builder.states = this.internalGetStates();
        builder.updatedAfter = this.internalGetUpdatedAfter();
        builder.updatedBefore = this.internalGetUpdatedBefore();
        builder.cursor = this.internalGetCursor();
        builder.limit = this.internalGetLimit();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> catalogObjectIds;
        private OptionalNullable<List<String>> locationIds;
        private OptionalNullable<List<String>> types;
        private OptionalNullable<List<String>> states;
        private OptionalNullable<String> updatedAfter;
        private OptionalNullable<String> updatedBefore;
        private OptionalNullable<String> cursor;
        private OptionalNullable<Integer> limit;

        public Builder catalogObjectIds(List<String> catalogObjectIds) {
            this.catalogObjectIds = OptionalNullable.of(catalogObjectIds);
            return this;
        }

        public Builder unsetCatalogObjectIds() {
            this.catalogObjectIds = null;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder types(List<String> types) {
            this.types = OptionalNullable.of(types);
            return this;
        }

        public Builder unsetTypes() {
            this.types = null;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = OptionalNullable.of(states);
            return this;
        }

        public Builder unsetStates() {
            this.states = null;
            return this;
        }

        public Builder updatedAfter(String updatedAfter) {
            this.updatedAfter = OptionalNullable.of((Object)updatedAfter);
            return this;
        }

        public Builder unsetUpdatedAfter() {
            this.updatedAfter = null;
            return this;
        }

        public Builder updatedBefore(String updatedBefore) {
            this.updatedBefore = OptionalNullable.of((Object)updatedBefore);
            return this;
        }

        public Builder unsetUpdatedBefore() {
            this.updatedBefore = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public BatchRetrieveInventoryChangesRequest build() {
            return new BatchRetrieveInventoryChangesRequest(this.catalogObjectIds, this.locationIds, this.types, this.states, this.updatedAfter, this.updatedBefore, this.cursor, this.limit);
        }
    }
}

