/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveInventoryCountsRequest {
    private final OptionalNullable<List<String>> catalogObjectIds;
    private final OptionalNullable<List<String>> locationIds;
    private final OptionalNullable<String> updatedAfter;
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<List<String>> states;
    private final OptionalNullable<Integer> limit;

    @JsonCreator
    public BatchRetrieveInventoryCountsRequest(@JsonProperty(value="catalog_object_ids") List<String> catalogObjectIds, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="updated_after") String updatedAfter, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="states") List<String> states, @JsonProperty(value="limit") Integer limit) {
        this.catalogObjectIds = OptionalNullable.of(catalogObjectIds);
        this.locationIds = OptionalNullable.of(locationIds);
        this.updatedAfter = OptionalNullable.of((Object)updatedAfter);
        this.cursor = OptionalNullable.of((Object)cursor);
        this.states = OptionalNullable.of(states);
        this.limit = OptionalNullable.of((Object)limit);
    }

    protected BatchRetrieveInventoryCountsRequest(OptionalNullable<List<String>> catalogObjectIds, OptionalNullable<List<String>> locationIds, OptionalNullable<String> updatedAfter, OptionalNullable<String> cursor, OptionalNullable<List<String>> states, OptionalNullable<Integer> limit) {
        this.catalogObjectIds = catalogObjectIds;
        this.locationIds = locationIds;
        this.updatedAfter = updatedAfter;
        this.cursor = cursor;
        this.states = states;
        this.limit = limit;
    }

    @JsonGetter(value="catalog_object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    @JsonIgnore
    public List<String> getCatalogObjectIds() {
        return (List)OptionalNullable.getFrom(this.catalogObjectIds);
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="updated_after")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUpdatedAfter() {
        return this.updatedAfter;
    }

    @JsonIgnore
    public String getUpdatedAfter() {
        return (String)OptionalNullable.getFrom(this.updatedAfter);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetStates() {
        return this.states;
    }

    @JsonIgnore
    public List<String> getStates() {
        return (List)OptionalNullable.getFrom(this.states);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectIds, this.locationIds, this.updatedAfter, this.cursor, this.states, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveInventoryCountsRequest)) {
            return false;
        }
        BatchRetrieveInventoryCountsRequest other = (BatchRetrieveInventoryCountsRequest)obj;
        return Objects.equals(this.catalogObjectIds, other.catalogObjectIds) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.updatedAfter, other.updatedAfter) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.states, other.states) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "BatchRetrieveInventoryCountsRequest [catalogObjectIds=" + this.catalogObjectIds + ", locationIds=" + this.locationIds + ", updatedAfter=" + this.updatedAfter + ", cursor=" + this.cursor + ", states=" + this.states + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.catalogObjectIds = this.internalGetCatalogObjectIds();
        builder.locationIds = this.internalGetLocationIds();
        builder.updatedAfter = this.internalGetUpdatedAfter();
        builder.cursor = this.internalGetCursor();
        builder.states = this.internalGetStates();
        builder.limit = this.internalGetLimit();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> catalogObjectIds;
        private OptionalNullable<List<String>> locationIds;
        private OptionalNullable<String> updatedAfter;
        private OptionalNullable<String> cursor;
        private OptionalNullable<List<String>> states;
        private OptionalNullable<Integer> limit;

        public Builder catalogObjectIds(List<String> catalogObjectIds) {
            this.catalogObjectIds = OptionalNullable.of(catalogObjectIds);
            return this;
        }

        public Builder unsetCatalogObjectIds() {
            this.catalogObjectIds = null;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder updatedAfter(String updatedAfter) {
            this.updatedAfter = OptionalNullable.of((Object)updatedAfter);
            return this;
        }

        public Builder unsetUpdatedAfter() {
            this.updatedAfter = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = OptionalNullable.of(states);
            return this;
        }

        public Builder unsetStates() {
            this.states = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public BatchRetrieveInventoryCountsRequest build() {
            return new BatchRetrieveInventoryCountsRequest(this.catalogObjectIds, this.locationIds, this.updatedAfter, this.cursor, this.states, this.limit);
        }
    }
}

