/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.AppointmentSegment;
import com.squareup.square.models.BookingCreatorDetails;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Booking {
    private final String id;
    private final Integer version;
    private final String status;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<String> startAt;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> customerId;
    private final OptionalNullable<String> customerNote;
    private final OptionalNullable<String> sellerNote;
    private final OptionalNullable<List<AppointmentSegment>> appointmentSegments;
    private final Integer transitionTimeMinutes;
    private final Boolean allDay;
    private final String locationType;
    private final BookingCreatorDetails creatorDetails;
    private final String source;

    @JsonCreator
    public Booking(@JsonProperty(value="id") String id, @JsonProperty(value="version") Integer version, @JsonProperty(value="status") String status, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="start_at") String startAt, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="customer_note") String customerNote, @JsonProperty(value="seller_note") String sellerNote, @JsonProperty(value="appointment_segments") List<AppointmentSegment> appointmentSegments, @JsonProperty(value="transition_time_minutes") Integer transitionTimeMinutes, @JsonProperty(value="all_day") Boolean allDay, @JsonProperty(value="location_type") String locationType, @JsonProperty(value="creator_details") BookingCreatorDetails creatorDetails, @JsonProperty(value="source") String source) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.startAt = OptionalNullable.of((Object)startAt);
        this.locationId = OptionalNullable.of((Object)locationId);
        this.customerId = OptionalNullable.of((Object)customerId);
        this.customerNote = OptionalNullable.of((Object)customerNote);
        this.sellerNote = OptionalNullable.of((Object)sellerNote);
        this.appointmentSegments = OptionalNullable.of(appointmentSegments);
        this.transitionTimeMinutes = transitionTimeMinutes;
        this.allDay = allDay;
        this.locationType = locationType;
        this.creatorDetails = creatorDetails;
        this.source = source;
    }

    protected Booking(String id, Integer version, String status, String createdAt, String updatedAt, OptionalNullable<String> startAt, OptionalNullable<String> locationId, OptionalNullable<String> customerId, OptionalNullable<String> customerNote, OptionalNullable<String> sellerNote, OptionalNullable<List<AppointmentSegment>> appointmentSegments, Integer transitionTimeMinutes, Boolean allDay, String locationType, BookingCreatorDetails creatorDetails, String source) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.startAt = startAt;
        this.locationId = locationId;
        this.customerId = customerId;
        this.customerNote = customerNote;
        this.sellerNote = sellerNote;
        this.appointmentSegments = appointmentSegments;
        this.transitionTimeMinutes = transitionTimeMinutes;
        this.allDay = allDay;
        this.locationType = locationType;
        this.creatorDetails = creatorDetails;
        this.source = source;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="start_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStartAt() {
        return this.startAt;
    }

    @JsonIgnore
    public String getStartAt() {
        return (String)OptionalNullable.getFrom(this.startAt);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="customer_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerNote() {
        return this.customerNote;
    }

    @JsonIgnore
    public String getCustomerNote() {
        return (String)OptionalNullable.getFrom(this.customerNote);
    }

    @JsonGetter(value="seller_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSellerNote() {
        return this.sellerNote;
    }

    @JsonIgnore
    public String getSellerNote() {
        return (String)OptionalNullable.getFrom(this.sellerNote);
    }

    @JsonGetter(value="appointment_segments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<AppointmentSegment>> internalGetAppointmentSegments() {
        return this.appointmentSegments;
    }

    @JsonIgnore
    public List<AppointmentSegment> getAppointmentSegments() {
        return (List)OptionalNullable.getFrom(this.appointmentSegments);
    }

    @JsonGetter(value="transition_time_minutes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getTransitionTimeMinutes() {
        return this.transitionTimeMinutes;
    }

    @JsonGetter(value="all_day")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAllDay() {
        return this.allDay;
    }

    @JsonGetter(value="location_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationType() {
        return this.locationType;
    }

    @JsonGetter(value="creator_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BookingCreatorDetails getCreatorDetails() {
        return this.creatorDetails;
    }

    @JsonGetter(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.status, this.createdAt, this.updatedAt, this.startAt, this.locationId, this.customerId, this.customerNote, this.sellerNote, this.appointmentSegments, this.transitionTimeMinutes, this.allDay, this.locationType, this.creatorDetails, this.source);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Booking)) {
            return false;
        }
        Booking other = (Booking)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.startAt, other.startAt) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.customerNote, other.customerNote) && Objects.equals(this.sellerNote, other.sellerNote) && Objects.equals(this.appointmentSegments, other.appointmentSegments) && Objects.equals(this.transitionTimeMinutes, other.transitionTimeMinutes) && Objects.equals(this.allDay, other.allDay) && Objects.equals(this.locationType, other.locationType) && Objects.equals(this.creatorDetails, other.creatorDetails) && Objects.equals(this.source, other.source);
    }

    public String toString() {
        return "Booking [id=" + this.id + ", version=" + this.version + ", status=" + this.status + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", startAt=" + this.startAt + ", locationId=" + this.locationId + ", customerId=" + this.customerId + ", customerNote=" + this.customerNote + ", sellerNote=" + this.sellerNote + ", appointmentSegments=" + this.appointmentSegments + ", transitionTimeMinutes=" + this.transitionTimeMinutes + ", allDay=" + this.allDay + ", locationType=" + this.locationType + ", creatorDetails=" + this.creatorDetails + ", source=" + this.source + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).version(this.getVersion()).status(this.getStatus()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).transitionTimeMinutes(this.getTransitionTimeMinutes()).allDay(this.getAllDay()).locationType(this.getLocationType()).creatorDetails(this.getCreatorDetails()).source(this.getSource());
        builder.startAt = this.internalGetStartAt();
        builder.locationId = this.internalGetLocationId();
        builder.customerId = this.internalGetCustomerId();
        builder.customerNote = this.internalGetCustomerNote();
        builder.sellerNote = this.internalGetSellerNote();
        builder.appointmentSegments = this.internalGetAppointmentSegments();
        return builder;
    }

    public static class Builder {
        private String id;
        private Integer version;
        private String status;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<String> startAt;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> customerId;
        private OptionalNullable<String> customerNote;
        private OptionalNullable<String> sellerNote;
        private OptionalNullable<List<AppointmentSegment>> appointmentSegments;
        private Integer transitionTimeMinutes;
        private Boolean allDay;
        private String locationType;
        private BookingCreatorDetails creatorDetails;
        private String source;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = OptionalNullable.of((Object)startAt);
            return this;
        }

        public Builder unsetStartAt() {
            this.startAt = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder customerNote(String customerNote) {
            this.customerNote = OptionalNullable.of((Object)customerNote);
            return this;
        }

        public Builder unsetCustomerNote() {
            this.customerNote = null;
            return this;
        }

        public Builder sellerNote(String sellerNote) {
            this.sellerNote = OptionalNullable.of((Object)sellerNote);
            return this;
        }

        public Builder unsetSellerNote() {
            this.sellerNote = null;
            return this;
        }

        public Builder appointmentSegments(List<AppointmentSegment> appointmentSegments) {
            this.appointmentSegments = OptionalNullable.of(appointmentSegments);
            return this;
        }

        public Builder unsetAppointmentSegments() {
            this.appointmentSegments = null;
            return this;
        }

        public Builder transitionTimeMinutes(Integer transitionTimeMinutes) {
            this.transitionTimeMinutes = transitionTimeMinutes;
            return this;
        }

        public Builder allDay(Boolean allDay) {
            this.allDay = allDay;
            return this;
        }

        public Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        public Builder creatorDetails(BookingCreatorDetails creatorDetails) {
            this.creatorDetails = creatorDetails;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Booking build() {
            return new Booking(this.id, this.version, this.status, this.createdAt, this.updatedAt, this.startAt, this.locationId, this.customerId, this.customerNote, this.sellerNote, this.appointmentSegments, this.transitionTimeMinutes, this.allDay, this.locationType, this.creatorDetails, this.source);
        }
    }
}

