/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomAttribute;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BookingCustomAttributeUpsertResponse {
    private final String bookingId;
    private final CustomAttribute customAttribute;
    private final List<Error> errors;

    @JsonCreator
    public BookingCustomAttributeUpsertResponse(@JsonProperty(value="booking_id") String bookingId, @JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="errors") List<Error> errors) {
        this.bookingId = bookingId;
        this.customAttribute = customAttribute;
        this.errors = errors;
    }

    @JsonGetter(value="booking_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonGetter(value="custom_attribute")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.customAttribute, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BookingCustomAttributeUpsertResponse)) {
            return false;
        }
        BookingCustomAttributeUpsertResponse other = (BookingCustomAttributeUpsertResponse)obj;
        return Objects.equals(this.bookingId, other.bookingId) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BookingCustomAttributeUpsertResponse [bookingId=" + this.bookingId + ", customAttribute=" + this.customAttribute + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().bookingId(this.getBookingId()).customAttribute(this.getCustomAttribute()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private String bookingId;
        private CustomAttribute customAttribute;
        private List<Error> errors;

        public Builder bookingId(String bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BookingCustomAttributeUpsertResponse build() {
            return new BookingCustomAttributeUpsertResponse(this.bookingId, this.customAttribute, this.errors);
        }
    }
}

