/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.RetrieveBookingResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BulkRetrieveBookingsResponse {
    private HttpContext httpContext;
    private final Map<String, RetrieveBookingResponse> bookings;
    private final List<Error> errors;

    @JsonCreator
    public BulkRetrieveBookingsResponse(@JsonProperty(value="bookings") Map<String, RetrieveBookingResponse> bookings, @JsonProperty(value="errors") List<Error> errors) {
        this.bookings = bookings;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="bookings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, RetrieveBookingResponse> getBookings() {
        return this.bookings;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.bookings, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkRetrieveBookingsResponse)) {
            return false;
        }
        BulkRetrieveBookingsResponse other = (BulkRetrieveBookingsResponse)obj;
        return Objects.equals(this.bookings, other.bookings) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BulkRetrieveBookingsResponse [bookings=" + this.bookings + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().bookings(this.getBookings()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Map<String, RetrieveBookingResponse> bookings;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder bookings(Map<String, RetrieveBookingResponse> bookings) {
            this.bookings = bookings;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BulkRetrieveBookingsResponse build() {
            BulkRetrieveBookingsResponse model = new BulkRetrieveBookingsResponse(this.bookings, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

