/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BulkRetrieveVendorsRequest {
    private final OptionalNullable<List<String>> vendorIds;

    @JsonCreator
    public BulkRetrieveVendorsRequest(@JsonProperty(value="vendor_ids") List<String> vendorIds) {
        this.vendorIds = OptionalNullable.of(vendorIds);
    }

    protected BulkRetrieveVendorsRequest(OptionalNullable<List<String>> vendorIds) {
        this.vendorIds = vendorIds;
    }

    @JsonGetter(value="vendor_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetVendorIds() {
        return this.vendorIds;
    }

    @JsonIgnore
    public List<String> getVendorIds() {
        return (List)OptionalNullable.getFrom(this.vendorIds);
    }

    public int hashCode() {
        return Objects.hash(this.vendorIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkRetrieveVendorsRequest)) {
            return false;
        }
        BulkRetrieveVendorsRequest other = (BulkRetrieveVendorsRequest)obj;
        return Objects.equals(this.vendorIds, other.vendorIds);
    }

    public String toString() {
        return "BulkRetrieveVendorsRequest [vendorIds=" + this.vendorIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.vendorIds = this.internalGetVendorIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> vendorIds;

        public Builder vendorIds(List<String> vendorIds) {
            this.vendorIds = OptionalNullable.of(vendorIds);
            return this;
        }

        public Builder unsetVendorIds() {
            this.vendorIds = null;
            return this;
        }

        public BulkRetrieveVendorsRequest build() {
            return new BulkRetrieveVendorsRequest(this.vendorIds);
        }
    }
}

