/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BulkSwapPlanRequest {
    private final String newPlanVariationId;
    private final String oldPlanVariationId;
    private final String locationId;

    @JsonCreator
    public BulkSwapPlanRequest(@JsonProperty(value="new_plan_variation_id") String newPlanVariationId, @JsonProperty(value="old_plan_variation_id") String oldPlanVariationId, @JsonProperty(value="location_id") String locationId) {
        this.newPlanVariationId = newPlanVariationId;
        this.oldPlanVariationId = oldPlanVariationId;
        this.locationId = locationId;
    }

    @JsonGetter(value="new_plan_variation_id")
    public String getNewPlanVariationId() {
        return this.newPlanVariationId;
    }

    @JsonGetter(value="old_plan_variation_id")
    public String getOldPlanVariationId() {
        return this.oldPlanVariationId;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.newPlanVariationId, this.oldPlanVariationId, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkSwapPlanRequest)) {
            return false;
        }
        BulkSwapPlanRequest other = (BulkSwapPlanRequest)obj;
        return Objects.equals(this.newPlanVariationId, other.newPlanVariationId) && Objects.equals(this.oldPlanVariationId, other.oldPlanVariationId) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "BulkSwapPlanRequest [newPlanVariationId=" + this.newPlanVariationId + ", oldPlanVariationId=" + this.oldPlanVariationId + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.newPlanVariationId, this.oldPlanVariationId, this.locationId);
        return builder;
    }

    public static class Builder {
        private String newPlanVariationId;
        private String oldPlanVariationId;
        private String locationId;

        public Builder(String newPlanVariationId, String oldPlanVariationId, String locationId) {
            this.newPlanVariationId = newPlanVariationId;
            this.oldPlanVariationId = oldPlanVariationId;
            this.locationId = locationId;
        }

        public Builder newPlanVariationId(String newPlanVariationId) {
            this.newPlanVariationId = newPlanVariationId;
            return this;
        }

        public Builder oldPlanVariationId(String oldPlanVariationId) {
            this.oldPlanVariationId = oldPlanVariationId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public BulkSwapPlanRequest build() {
            return new BulkSwapPlanRequest(this.newPlanVariationId, this.oldPlanVariationId, this.locationId);
        }
    }
}

