/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BulkSwapPlanResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Integer affectedSubscriptions;

    @JsonCreator
    public BulkSwapPlanResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="affected_subscriptions") Integer affectedSubscriptions) {
        this.errors = errors;
        this.affectedSubscriptions = affectedSubscriptions;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="affected_subscriptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getAffectedSubscriptions() {
        return this.affectedSubscriptions;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.affectedSubscriptions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkSwapPlanResponse)) {
            return false;
        }
        BulkSwapPlanResponse other = (BulkSwapPlanResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.affectedSubscriptions, other.affectedSubscriptions);
    }

    public String toString() {
        return "BulkSwapPlanResponse [errors=" + this.errors + ", affectedSubscriptions=" + this.affectedSubscriptions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).affectedSubscriptions(this.getAffectedSubscriptions());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Integer affectedSubscriptions;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder affectedSubscriptions(Integer affectedSubscriptions) {
            this.affectedSubscriptions = affectedSubscriptions;
            return this;
        }

        public BulkSwapPlanResponse build() {
            BulkSwapPlanResponse model = new BulkSwapPlanResponse(this.errors, this.affectedSubscriptions);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

