/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomAttribute;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse {
    private final String merchantId;
    private final CustomAttribute customAttribute;
    private final List<Error> errors;

    @JsonCreator
    public BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse(@JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="errors") List<Error> errors) {
        this.merchantId = merchantId;
        this.customAttribute = customAttribute;
        this.errors = errors;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="custom_attribute")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.customAttribute, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse)) {
            return false;
        }
        BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse other = (BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse)obj;
        return Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse [merchantId=" + this.merchantId + ", customAttribute=" + this.customAttribute + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().merchantId(this.getMerchantId()).customAttribute(this.getCustomAttribute()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private String merchantId;
        private CustomAttribute customAttribute;
        private List<Error> errors;

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse build() {
            return new BulkUpsertMerchantCustomAttributesResponseMerchantCustomAttributeUpsertResponse(this.merchantId, this.customAttribute, this.errors);
        }
    }
}

