/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttribute;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute {
    private final CustomAttribute customAttribute;
    private final OptionalNullable<String> idempotencyKey;
    private final String orderId;

    @JsonCreator
    public BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute(@JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.customAttribute = customAttribute;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
        this.orderId = orderId;
    }

    protected BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute(CustomAttribute customAttribute, String orderId, OptionalNullable<String> idempotencyKey) {
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
        this.orderId = orderId;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    @JsonGetter(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    public int hashCode() {
        return Objects.hash(this.customAttribute, this.idempotencyKey, this.orderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute)) {
            return false;
        }
        BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute other = (BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute)obj;
        return Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.orderId, other.orderId);
    }

    public String toString() {
        return "BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute [customAttribute=" + this.customAttribute + ", orderId=" + this.orderId + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customAttribute, this.orderId);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private CustomAttribute customAttribute;
        private String orderId;
        private OptionalNullable<String> idempotencyKey;

        public Builder(CustomAttribute customAttribute, String orderId) {
            this.customAttribute = customAttribute;
            this.orderId = orderId;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute build() {
            return new BulkUpsertOrderCustomAttributesRequestUpsertCustomAttribute(this.customAttribute, this.orderId, this.idempotencyKey);
        }
    }
}

