/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BusinessHoursPeriod {
    private final String dayOfWeek;
    private final OptionalNullable<String> startLocalTime;
    private final OptionalNullable<String> endLocalTime;

    @JsonCreator
    public BusinessHoursPeriod(@JsonProperty(value="day_of_week") String dayOfWeek, @JsonProperty(value="start_local_time") String startLocalTime, @JsonProperty(value="end_local_time") String endLocalTime) {
        this.dayOfWeek = dayOfWeek;
        this.startLocalTime = OptionalNullable.of((Object)startLocalTime);
        this.endLocalTime = OptionalNullable.of((Object)endLocalTime);
    }

    protected BusinessHoursPeriod(String dayOfWeek, OptionalNullable<String> startLocalTime, OptionalNullable<String> endLocalTime) {
        this.dayOfWeek = dayOfWeek;
        this.startLocalTime = startLocalTime;
        this.endLocalTime = endLocalTime;
    }

    @JsonGetter(value="day_of_week")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    @JsonGetter(value="start_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStartLocalTime() {
        return this.startLocalTime;
    }

    @JsonIgnore
    public String getStartLocalTime() {
        return (String)OptionalNullable.getFrom(this.startLocalTime);
    }

    @JsonGetter(value="end_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndLocalTime() {
        return this.endLocalTime;
    }

    @JsonIgnore
    public String getEndLocalTime() {
        return (String)OptionalNullable.getFrom(this.endLocalTime);
    }

    public int hashCode() {
        return Objects.hash(this.dayOfWeek, this.startLocalTime, this.endLocalTime);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BusinessHoursPeriod)) {
            return false;
        }
        BusinessHoursPeriod other = (BusinessHoursPeriod)obj;
        return Objects.equals(this.dayOfWeek, other.dayOfWeek) && Objects.equals(this.startLocalTime, other.startLocalTime) && Objects.equals(this.endLocalTime, other.endLocalTime);
    }

    public String toString() {
        return "BusinessHoursPeriod [dayOfWeek=" + this.dayOfWeek + ", startLocalTime=" + this.startLocalTime + ", endLocalTime=" + this.endLocalTime + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().dayOfWeek(this.getDayOfWeek());
        builder.startLocalTime = this.internalGetStartLocalTime();
        builder.endLocalTime = this.internalGetEndLocalTime();
        return builder;
    }

    public static class Builder {
        private String dayOfWeek;
        private OptionalNullable<String> startLocalTime;
        private OptionalNullable<String> endLocalTime;

        public Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public Builder startLocalTime(String startLocalTime) {
            this.startLocalTime = OptionalNullable.of((Object)startLocalTime);
            return this;
        }

        public Builder unsetStartLocalTime() {
            this.startLocalTime = null;
            return this;
        }

        public Builder endLocalTime(String endLocalTime) {
            this.endLocalTime = OptionalNullable.of((Object)endLocalTime);
            return this;
        }

        public Builder unsetEndLocalTime() {
            this.endLocalTime = null;
            return this;
        }

        public BusinessHoursPeriod build() {
            return new BusinessHoursPeriod(this.dayOfWeek, this.startLocalTime, this.endLocalTime);
        }
    }
}

