/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class CalculateLoyaltyPointsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Integer points;
    private final Integer promotionPoints;

    @JsonCreator
    public CalculateLoyaltyPointsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="points") Integer points, @JsonProperty(value="promotion_points") Integer promotionPoints) {
        this.errors = errors;
        this.points = points;
        this.promotionPoints = promotionPoints;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPoints() {
        return this.points;
    }

    @JsonGetter(value="promotion_points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPromotionPoints() {
        return this.promotionPoints;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.points, this.promotionPoints);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CalculateLoyaltyPointsResponse)) {
            return false;
        }
        CalculateLoyaltyPointsResponse other = (CalculateLoyaltyPointsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.points, other.points) && Objects.equals(this.promotionPoints, other.promotionPoints);
    }

    public String toString() {
        return "CalculateLoyaltyPointsResponse [errors=" + this.errors + ", points=" + this.points + ", promotionPoints=" + this.promotionPoints + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).points(this.getPoints()).promotionPoints(this.getPromotionPoints());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Integer points;
        private Integer promotionPoints;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder points(Integer points) {
            this.points = points;
            return this;
        }

        public Builder promotionPoints(Integer promotionPoints) {
            this.promotionPoints = promotionPoints;
            return this;
        }

        public CalculateLoyaltyPointsResponse build() {
            CalculateLoyaltyPointsResponse model = new CalculateLoyaltyPointsResponse(this.errors, this.points, this.promotionPoints);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

