/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CancelBookingRequest {
    private final OptionalNullable<String> idempotencyKey;
    private final OptionalNullable<Integer> bookingVersion;

    @JsonCreator
    public CancelBookingRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="booking_version") Integer bookingVersion) {
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
        this.bookingVersion = OptionalNullable.of((Object)bookingVersion);
    }

    protected CancelBookingRequest(OptionalNullable<String> idempotencyKey, OptionalNullable<Integer> bookingVersion) {
        this.idempotencyKey = idempotencyKey;
        this.bookingVersion = bookingVersion;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    @JsonGetter(value="booking_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetBookingVersion() {
        return this.bookingVersion;
    }

    @JsonIgnore
    public Integer getBookingVersion() {
        return (Integer)OptionalNullable.getFrom(this.bookingVersion);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.bookingVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CancelBookingRequest)) {
            return false;
        }
        CancelBookingRequest other = (CancelBookingRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.bookingVersion, other.bookingVersion);
    }

    public String toString() {
        return "CancelBookingRequest [idempotencyKey=" + this.idempotencyKey + ", bookingVersion=" + this.bookingVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        builder.bookingVersion = this.internalGetBookingVersion();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> idempotencyKey;
        private OptionalNullable<Integer> bookingVersion;

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public Builder bookingVersion(Integer bookingVersion) {
            this.bookingVersion = OptionalNullable.of((Object)bookingVersion);
            return this;
        }

        public Builder unsetBookingVersion() {
            this.bookingVersion = null;
            return this;
        }

        public CancelBookingRequest build() {
            return new CancelBookingRequest(this.idempotencyKey, this.bookingVersion);
        }
    }
}

