/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Payment;
import java.util.List;
import java.util.Objects;

public class CancelPaymentResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Payment payment;

    @JsonCreator
    public CancelPaymentResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="payment") Payment payment) {
        this.errors = errors;
        this.payment = payment;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="payment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Payment getPayment() {
        return this.payment;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.payment);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CancelPaymentResponse)) {
            return false;
        }
        CancelPaymentResponse other = (CancelPaymentResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.payment, other.payment);
    }

    public String toString() {
        return "CancelPaymentResponse [errors=" + this.errors + ", payment=" + this.payment + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).payment(this.getPayment());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Payment payment;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder payment(Payment payment) {
            this.payment = payment;
            return this;
        }

        public CancelPaymentResponse build() {
            CancelPaymentResponse model = new CancelPaymentResponse(this.errors, this.payment);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

