/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CardPaymentTimeline {
    private final OptionalNullable<String> authorizedAt;
    private final OptionalNullable<String> capturedAt;
    private final OptionalNullable<String> voidedAt;

    @JsonCreator
    public CardPaymentTimeline(@JsonProperty(value="authorized_at") String authorizedAt, @JsonProperty(value="captured_at") String capturedAt, @JsonProperty(value="voided_at") String voidedAt) {
        this.authorizedAt = OptionalNullable.of((Object)authorizedAt);
        this.capturedAt = OptionalNullable.of((Object)capturedAt);
        this.voidedAt = OptionalNullable.of((Object)voidedAt);
    }

    protected CardPaymentTimeline(OptionalNullable<String> authorizedAt, OptionalNullable<String> capturedAt, OptionalNullable<String> voidedAt) {
        this.authorizedAt = authorizedAt;
        this.capturedAt = capturedAt;
        this.voidedAt = voidedAt;
    }

    @JsonGetter(value="authorized_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAuthorizedAt() {
        return this.authorizedAt;
    }

    @JsonIgnore
    public String getAuthorizedAt() {
        return (String)OptionalNullable.getFrom(this.authorizedAt);
    }

    @JsonGetter(value="captured_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCapturedAt() {
        return this.capturedAt;
    }

    @JsonIgnore
    public String getCapturedAt() {
        return (String)OptionalNullable.getFrom(this.capturedAt);
    }

    @JsonGetter(value="voided_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetVoidedAt() {
        return this.voidedAt;
    }

    @JsonIgnore
    public String getVoidedAt() {
        return (String)OptionalNullable.getFrom(this.voidedAt);
    }

    public int hashCode() {
        return Objects.hash(this.authorizedAt, this.capturedAt, this.voidedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CardPaymentTimeline)) {
            return false;
        }
        CardPaymentTimeline other = (CardPaymentTimeline)obj;
        return Objects.equals(this.authorizedAt, other.authorizedAt) && Objects.equals(this.capturedAt, other.capturedAt) && Objects.equals(this.voidedAt, other.voidedAt);
    }

    public String toString() {
        return "CardPaymentTimeline [authorizedAt=" + this.authorizedAt + ", capturedAt=" + this.capturedAt + ", voidedAt=" + this.voidedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.authorizedAt = this.internalGetAuthorizedAt();
        builder.capturedAt = this.internalGetCapturedAt();
        builder.voidedAt = this.internalGetVoidedAt();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> authorizedAt;
        private OptionalNullable<String> capturedAt;
        private OptionalNullable<String> voidedAt;

        public Builder authorizedAt(String authorizedAt) {
            this.authorizedAt = OptionalNullable.of((Object)authorizedAt);
            return this;
        }

        public Builder unsetAuthorizedAt() {
            this.authorizedAt = null;
            return this;
        }

        public Builder capturedAt(String capturedAt) {
            this.capturedAt = OptionalNullable.of((Object)capturedAt);
            return this;
        }

        public Builder unsetCapturedAt() {
            this.capturedAt = null;
            return this;
        }

        public Builder voidedAt(String voidedAt) {
            this.voidedAt = OptionalNullable.of((Object)voidedAt);
            return this;
        }

        public Builder unsetVoidedAt() {
            this.voidedAt = null;
            return this;
        }

        public CardPaymentTimeline build() {
            return new CardPaymentTimeline(this.authorizedAt, this.capturedAt, this.voidedAt);
        }
    }
}

