/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CashAppDetails {
    private final OptionalNullable<String> buyerFullName;
    private final OptionalNullable<String> buyerCountryCode;
    private final String buyerCashtag;

    @JsonCreator
    public CashAppDetails(@JsonProperty(value="buyer_full_name") String buyerFullName, @JsonProperty(value="buyer_country_code") String buyerCountryCode, @JsonProperty(value="buyer_cashtag") String buyerCashtag) {
        this.buyerFullName = OptionalNullable.of((Object)buyerFullName);
        this.buyerCountryCode = OptionalNullable.of((Object)buyerCountryCode);
        this.buyerCashtag = buyerCashtag;
    }

    protected CashAppDetails(OptionalNullable<String> buyerFullName, OptionalNullable<String> buyerCountryCode, String buyerCashtag) {
        this.buyerFullName = buyerFullName;
        this.buyerCountryCode = buyerCountryCode;
        this.buyerCashtag = buyerCashtag;
    }

    @JsonGetter(value="buyer_full_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerFullName() {
        return this.buyerFullName;
    }

    @JsonIgnore
    public String getBuyerFullName() {
        return (String)OptionalNullable.getFrom(this.buyerFullName);
    }

    @JsonGetter(value="buyer_country_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBuyerCountryCode() {
        return this.buyerCountryCode;
    }

    @JsonIgnore
    public String getBuyerCountryCode() {
        return (String)OptionalNullable.getFrom(this.buyerCountryCode);
    }

    @JsonGetter(value="buyer_cashtag")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBuyerCashtag() {
        return this.buyerCashtag;
    }

    public int hashCode() {
        return Objects.hash(this.buyerFullName, this.buyerCountryCode, this.buyerCashtag);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashAppDetails)) {
            return false;
        }
        CashAppDetails other = (CashAppDetails)obj;
        return Objects.equals(this.buyerFullName, other.buyerFullName) && Objects.equals(this.buyerCountryCode, other.buyerCountryCode) && Objects.equals(this.buyerCashtag, other.buyerCashtag);
    }

    public String toString() {
        return "CashAppDetails [buyerFullName=" + this.buyerFullName + ", buyerCountryCode=" + this.buyerCountryCode + ", buyerCashtag=" + this.buyerCashtag + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().buyerCashtag(this.getBuyerCashtag());
        builder.buyerFullName = this.internalGetBuyerFullName();
        builder.buyerCountryCode = this.internalGetBuyerCountryCode();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> buyerFullName;
        private OptionalNullable<String> buyerCountryCode;
        private String buyerCashtag;

        public Builder buyerFullName(String buyerFullName) {
            this.buyerFullName = OptionalNullable.of((Object)buyerFullName);
            return this;
        }

        public Builder unsetBuyerFullName() {
            this.buyerFullName = null;
            return this;
        }

        public Builder buyerCountryCode(String buyerCountryCode) {
            this.buyerCountryCode = OptionalNullable.of((Object)buyerCountryCode);
            return this;
        }

        public Builder unsetBuyerCountryCode() {
            this.buyerCountryCode = null;
            return this;
        }

        public Builder buyerCashtag(String buyerCashtag) {
            this.buyerCashtag = buyerCashtag;
            return this;
        }

        public CashAppDetails build() {
            return new CashAppDetails(this.buyerFullName, this.buyerCountryCode, this.buyerCashtag);
        }
    }
}

