/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CashDrawerShiftEvent {
    private final String id;
    private final String eventType;
    private final Money eventMoney;
    private final String createdAt;
    private final OptionalNullable<String> description;
    private final String teamMemberId;

    @JsonCreator
    public CashDrawerShiftEvent(@JsonProperty(value="id") String id, @JsonProperty(value="event_type") String eventType, @JsonProperty(value="event_money") Money eventMoney, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="description") String description, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.id = id;
        this.eventType = eventType;
        this.eventMoney = eventMoney;
        this.createdAt = createdAt;
        this.description = OptionalNullable.of((Object)description);
        this.teamMemberId = teamMemberId;
    }

    protected CashDrawerShiftEvent(String id, String eventType, Money eventMoney, String createdAt, OptionalNullable<String> description, String teamMemberId) {
        this.id = id;
        this.eventType = eventType;
        this.eventMoney = eventMoney;
        this.createdAt = createdAt;
        this.description = description;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="event_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEventType() {
        return this.eventType;
    }

    @JsonGetter(value="event_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getEventMoney() {
        return this.eventMoney;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescription() {
        return (String)OptionalNullable.getFrom(this.description);
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventType, this.eventMoney, this.createdAt, this.description, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerShiftEvent)) {
            return false;
        }
        CashDrawerShiftEvent other = (CashDrawerShiftEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.eventMoney, other.eventMoney) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.description, other.description) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "CashDrawerShiftEvent [id=" + this.id + ", eventType=" + this.eventType + ", eventMoney=" + this.eventMoney + ", createdAt=" + this.createdAt + ", description=" + this.description + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).eventType(this.getEventType()).eventMoney(this.getEventMoney()).createdAt(this.getCreatedAt()).teamMemberId(this.getTeamMemberId());
        builder.description = this.internalGetDescription();
        return builder;
    }

    public static class Builder {
        private String id;
        private String eventType;
        private Money eventMoney;
        private String createdAt;
        private OptionalNullable<String> description;
        private String teamMemberId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder eventMoney(Money eventMoney) {
            this.eventMoney = eventMoney;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder description(String description) {
            this.description = OptionalNullable.of((Object)description);
            return this;
        }

        public Builder unsetDescription() {
            this.description = null;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public CashDrawerShiftEvent build() {
            return new CashDrawerShiftEvent(this.id, this.eventType, this.eventMoney, this.createdAt, this.description, this.teamMemberId);
        }
    }
}

