/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CashDrawerShiftSummary {
    private final String id;
    private final String state;
    private final OptionalNullable<String> openedAt;
    private final OptionalNullable<String> endedAt;
    private final OptionalNullable<String> closedAt;
    private final OptionalNullable<String> description;
    private final Money openedCashMoney;
    private final Money expectedCashMoney;
    private final Money closedCashMoney;
    private final String createdAt;
    private final String updatedAt;
    private final String locationId;

    @JsonCreator
    public CashDrawerShiftSummary(@JsonProperty(value="id") String id, @JsonProperty(value="state") String state, @JsonProperty(value="opened_at") String openedAt, @JsonProperty(value="ended_at") String endedAt, @JsonProperty(value="closed_at") String closedAt, @JsonProperty(value="description") String description, @JsonProperty(value="opened_cash_money") Money openedCashMoney, @JsonProperty(value="expected_cash_money") Money expectedCashMoney, @JsonProperty(value="closed_cash_money") Money closedCashMoney, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="location_id") String locationId) {
        this.id = id;
        this.state = state;
        this.openedAt = OptionalNullable.of((Object)openedAt);
        this.endedAt = OptionalNullable.of((Object)endedAt);
        this.closedAt = OptionalNullable.of((Object)closedAt);
        this.description = OptionalNullable.of((Object)description);
        this.openedCashMoney = openedCashMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locationId = locationId;
    }

    protected CashDrawerShiftSummary(String id, String state, OptionalNullable<String> openedAt, OptionalNullable<String> endedAt, OptionalNullable<String> closedAt, OptionalNullable<String> description, Money openedCashMoney, Money expectedCashMoney, Money closedCashMoney, String createdAt, String updatedAt, String locationId) {
        this.id = id;
        this.state = state;
        this.openedAt = openedAt;
        this.endedAt = endedAt;
        this.closedAt = closedAt;
        this.description = description;
        this.openedCashMoney = openedCashMoney;
        this.expectedCashMoney = expectedCashMoney;
        this.closedCashMoney = closedCashMoney;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.locationId = locationId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="opened_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOpenedAt() {
        return this.openedAt;
    }

    @JsonIgnore
    public String getOpenedAt() {
        return (String)OptionalNullable.getFrom(this.openedAt);
    }

    @JsonGetter(value="ended_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndedAt() {
        return this.endedAt;
    }

    @JsonIgnore
    public String getEndedAt() {
        return (String)OptionalNullable.getFrom(this.endedAt);
    }

    @JsonGetter(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetClosedAt() {
        return this.closedAt;
    }

    @JsonIgnore
    public String getClosedAt() {
        return (String)OptionalNullable.getFrom(this.closedAt);
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescription() {
        return (String)OptionalNullable.getFrom(this.description);
    }

    @JsonGetter(value="opened_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getOpenedCashMoney() {
        return this.openedCashMoney;
    }

    @JsonGetter(value="expected_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getExpectedCashMoney() {
        return this.expectedCashMoney;
    }

    @JsonGetter(value="closed_cash_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getClosedCashMoney() {
        return this.closedCashMoney;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.expectedCashMoney, this.closedCashMoney, this.createdAt, this.updatedAt, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CashDrawerShiftSummary)) {
            return false;
        }
        CashDrawerShiftSummary other = (CashDrawerShiftSummary)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.state, other.state) && Objects.equals(this.openedAt, other.openedAt) && Objects.equals(this.endedAt, other.endedAt) && Objects.equals(this.closedAt, other.closedAt) && Objects.equals(this.description, other.description) && Objects.equals(this.openedCashMoney, other.openedCashMoney) && Objects.equals(this.expectedCashMoney, other.expectedCashMoney) && Objects.equals(this.closedCashMoney, other.closedCashMoney) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "CashDrawerShiftSummary [id=" + this.id + ", state=" + this.state + ", openedAt=" + this.openedAt + ", endedAt=" + this.endedAt + ", closedAt=" + this.closedAt + ", description=" + this.description + ", openedCashMoney=" + this.openedCashMoney + ", expectedCashMoney=" + this.expectedCashMoney + ", closedCashMoney=" + this.closedCashMoney + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).state(this.getState()).openedCashMoney(this.getOpenedCashMoney()).expectedCashMoney(this.getExpectedCashMoney()).closedCashMoney(this.getClosedCashMoney()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).locationId(this.getLocationId());
        builder.openedAt = this.internalGetOpenedAt();
        builder.endedAt = this.internalGetEndedAt();
        builder.closedAt = this.internalGetClosedAt();
        builder.description = this.internalGetDescription();
        return builder;
    }

    public static class Builder {
        private String id;
        private String state;
        private OptionalNullable<String> openedAt;
        private OptionalNullable<String> endedAt;
        private OptionalNullable<String> closedAt;
        private OptionalNullable<String> description;
        private Money openedCashMoney;
        private Money expectedCashMoney;
        private Money closedCashMoney;
        private String createdAt;
        private String updatedAt;
        private String locationId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder openedAt(String openedAt) {
            this.openedAt = OptionalNullable.of((Object)openedAt);
            return this;
        }

        public Builder unsetOpenedAt() {
            this.openedAt = null;
            return this;
        }

        public Builder endedAt(String endedAt) {
            this.endedAt = OptionalNullable.of((Object)endedAt);
            return this;
        }

        public Builder unsetEndedAt() {
            this.endedAt = null;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = OptionalNullable.of((Object)closedAt);
            return this;
        }

        public Builder unsetClosedAt() {
            this.closedAt = null;
            return this;
        }

        public Builder description(String description) {
            this.description = OptionalNullable.of((Object)description);
            return this;
        }

        public Builder unsetDescription() {
            this.description = null;
            return this;
        }

        public Builder openedCashMoney(Money openedCashMoney) {
            this.openedCashMoney = openedCashMoney;
            return this;
        }

        public Builder expectedCashMoney(Money expectedCashMoney) {
            this.expectedCashMoney = expectedCashMoney;
            return this;
        }

        public Builder closedCashMoney(Money closedCashMoney) {
            this.closedCashMoney = closedCashMoney;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public CashDrawerShiftSummary build() {
            return new CashDrawerShiftSummary(this.id, this.state, this.openedAt, this.endedAt, this.closedAt, this.description, this.openedCashMoney, this.expectedCashMoney, this.closedCashMoney, this.createdAt, this.updatedAt, this.locationId);
        }
    }
}

