/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogAvailabilityPeriod {
    private final OptionalNullable<String> startLocalTime;
    private final OptionalNullable<String> endLocalTime;
    private final String dayOfWeek;

    @JsonCreator
    public CatalogAvailabilityPeriod(@JsonProperty(value="start_local_time") String startLocalTime, @JsonProperty(value="end_local_time") String endLocalTime, @JsonProperty(value="day_of_week") String dayOfWeek) {
        this.startLocalTime = OptionalNullable.of((Object)startLocalTime);
        this.endLocalTime = OptionalNullable.of((Object)endLocalTime);
        this.dayOfWeek = dayOfWeek;
    }

    protected CatalogAvailabilityPeriod(OptionalNullable<String> startLocalTime, OptionalNullable<String> endLocalTime, String dayOfWeek) {
        this.startLocalTime = startLocalTime;
        this.endLocalTime = endLocalTime;
        this.dayOfWeek = dayOfWeek;
    }

    @JsonGetter(value="start_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStartLocalTime() {
        return this.startLocalTime;
    }

    @JsonIgnore
    public String getStartLocalTime() {
        return (String)OptionalNullable.getFrom(this.startLocalTime);
    }

    @JsonGetter(value="end_local_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndLocalTime() {
        return this.endLocalTime;
    }

    @JsonIgnore
    public String getEndLocalTime() {
        return (String)OptionalNullable.getFrom(this.endLocalTime);
    }

    @JsonGetter(value="day_of_week")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int hashCode() {
        return Objects.hash(this.startLocalTime, this.endLocalTime, this.dayOfWeek);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogAvailabilityPeriod)) {
            return false;
        }
        CatalogAvailabilityPeriod other = (CatalogAvailabilityPeriod)obj;
        return Objects.equals(this.startLocalTime, other.startLocalTime) && Objects.equals(this.endLocalTime, other.endLocalTime) && Objects.equals(this.dayOfWeek, other.dayOfWeek);
    }

    public String toString() {
        return "CatalogAvailabilityPeriod [startLocalTime=" + this.startLocalTime + ", endLocalTime=" + this.endLocalTime + ", dayOfWeek=" + this.dayOfWeek + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().dayOfWeek(this.getDayOfWeek());
        builder.startLocalTime = this.internalGetStartLocalTime();
        builder.endLocalTime = this.internalGetEndLocalTime();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> startLocalTime;
        private OptionalNullable<String> endLocalTime;
        private String dayOfWeek;

        public Builder startLocalTime(String startLocalTime) {
            this.startLocalTime = OptionalNullable.of((Object)startLocalTime);
            return this;
        }

        public Builder unsetStartLocalTime() {
            this.startLocalTime = null;
            return this;
        }

        public Builder endLocalTime(String endLocalTime) {
            this.endLocalTime = OptionalNullable.of((Object)endLocalTime);
            return this;
        }

        public Builder unsetEndLocalTime() {
            this.endLocalTime = null;
            return this;
        }

        public Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public CatalogAvailabilityPeriod build() {
            return new CatalogAvailabilityPeriod(this.startLocalTime, this.endLocalTime, this.dayOfWeek);
        }
    }
}

