/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogEcomSeoData;
import com.squareup.square.models.CatalogObjectCategory;
import com.squareup.square.models.CategoryPathToRootNode;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogCategory {
    private final OptionalNullable<String> name;
    private final OptionalNullable<List<String>> imageIds;
    private final String categoryType;
    private final CatalogObjectCategory parentCategory;
    private final OptionalNullable<Boolean> isTopLevel;
    private final OptionalNullable<List<String>> channels;
    private final OptionalNullable<List<String>> availabilityPeriodIds;
    private final OptionalNullable<Boolean> onlineVisibility;
    private final String rootCategory;
    private final CatalogEcomSeoData ecomSeoData;
    private final OptionalNullable<List<CategoryPathToRootNode>> pathToRoot;

    @JsonCreator
    public CatalogCategory(@JsonProperty(value="name") String name, @JsonProperty(value="image_ids") List<String> imageIds, @JsonProperty(value="category_type") String categoryType, @JsonProperty(value="parent_category") CatalogObjectCategory parentCategory, @JsonProperty(value="is_top_level") Boolean isTopLevel, @JsonProperty(value="channels") List<String> channels, @JsonProperty(value="availability_period_ids") List<String> availabilityPeriodIds, @JsonProperty(value="online_visibility") Boolean onlineVisibility, @JsonProperty(value="root_category") String rootCategory, @JsonProperty(value="ecom_seo_data") CatalogEcomSeoData ecomSeoData, @JsonProperty(value="path_to_root") List<CategoryPathToRootNode> pathToRoot) {
        this.name = OptionalNullable.of((Object)name);
        this.imageIds = OptionalNullable.of(imageIds);
        this.categoryType = categoryType;
        this.parentCategory = parentCategory;
        this.isTopLevel = OptionalNullable.of((Object)isTopLevel);
        this.channels = OptionalNullable.of(channels);
        this.availabilityPeriodIds = OptionalNullable.of(availabilityPeriodIds);
        this.onlineVisibility = OptionalNullable.of((Object)onlineVisibility);
        this.rootCategory = rootCategory;
        this.ecomSeoData = ecomSeoData;
        this.pathToRoot = OptionalNullable.of(pathToRoot);
    }

    protected CatalogCategory(OptionalNullable<String> name, OptionalNullable<List<String>> imageIds, String categoryType, CatalogObjectCategory parentCategory, OptionalNullable<Boolean> isTopLevel, OptionalNullable<List<String>> channels, OptionalNullable<List<String>> availabilityPeriodIds, OptionalNullable<Boolean> onlineVisibility, String rootCategory, CatalogEcomSeoData ecomSeoData, OptionalNullable<List<CategoryPathToRootNode>> pathToRoot) {
        this.name = name;
        this.imageIds = imageIds;
        this.categoryType = categoryType;
        this.parentCategory = parentCategory;
        this.isTopLevel = isTopLevel;
        this.channels = channels;
        this.availabilityPeriodIds = availabilityPeriodIds;
        this.onlineVisibility = onlineVisibility;
        this.rootCategory = rootCategory;
        this.ecomSeoData = ecomSeoData;
        this.pathToRoot = pathToRoot;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="image_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetImageIds() {
        return this.imageIds;
    }

    @JsonIgnore
    public List<String> getImageIds() {
        return (List)OptionalNullable.getFrom(this.imageIds);
    }

    @JsonGetter(value="category_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCategoryType() {
        return this.categoryType;
    }

    @JsonGetter(value="parent_category")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogObjectCategory getParentCategory() {
        return this.parentCategory;
    }

    @JsonGetter(value="is_top_level")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsTopLevel() {
        return this.isTopLevel;
    }

    @JsonIgnore
    public Boolean getIsTopLevel() {
        return (Boolean)OptionalNullable.getFrom(this.isTopLevel);
    }

    @JsonGetter(value="channels")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetChannels() {
        return this.channels;
    }

    @JsonIgnore
    public List<String> getChannels() {
        return (List)OptionalNullable.getFrom(this.channels);
    }

    @JsonGetter(value="availability_period_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetAvailabilityPeriodIds() {
        return this.availabilityPeriodIds;
    }

    @JsonIgnore
    public List<String> getAvailabilityPeriodIds() {
        return (List)OptionalNullable.getFrom(this.availabilityPeriodIds);
    }

    @JsonGetter(value="online_visibility")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetOnlineVisibility() {
        return this.onlineVisibility;
    }

    @JsonIgnore
    public Boolean getOnlineVisibility() {
        return (Boolean)OptionalNullable.getFrom(this.onlineVisibility);
    }

    @JsonGetter(value="root_category")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRootCategory() {
        return this.rootCategory;
    }

    @JsonGetter(value="ecom_seo_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogEcomSeoData getEcomSeoData() {
        return this.ecomSeoData;
    }

    @JsonGetter(value="path_to_root")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CategoryPathToRootNode>> internalGetPathToRoot() {
        return this.pathToRoot;
    }

    @JsonIgnore
    public List<CategoryPathToRootNode> getPathToRoot() {
        return (List)OptionalNullable.getFrom(this.pathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.imageIds, this.categoryType, this.parentCategory, this.isTopLevel, this.channels, this.availabilityPeriodIds, this.onlineVisibility, this.rootCategory, this.ecomSeoData, this.pathToRoot);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogCategory)) {
            return false;
        }
        CatalogCategory other = (CatalogCategory)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.imageIds, other.imageIds) && Objects.equals(this.categoryType, other.categoryType) && Objects.equals(this.parentCategory, other.parentCategory) && Objects.equals(this.isTopLevel, other.isTopLevel) && Objects.equals(this.channels, other.channels) && Objects.equals(this.availabilityPeriodIds, other.availabilityPeriodIds) && Objects.equals(this.onlineVisibility, other.onlineVisibility) && Objects.equals(this.rootCategory, other.rootCategory) && Objects.equals(this.ecomSeoData, other.ecomSeoData) && Objects.equals(this.pathToRoot, other.pathToRoot);
    }

    public String toString() {
        return "CatalogCategory [name=" + this.name + ", imageIds=" + this.imageIds + ", categoryType=" + this.categoryType + ", parentCategory=" + this.parentCategory + ", isTopLevel=" + this.isTopLevel + ", channels=" + this.channels + ", availabilityPeriodIds=" + this.availabilityPeriodIds + ", onlineVisibility=" + this.onlineVisibility + ", rootCategory=" + this.rootCategory + ", ecomSeoData=" + this.ecomSeoData + ", pathToRoot=" + this.pathToRoot + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().categoryType(this.getCategoryType()).parentCategory(this.getParentCategory()).rootCategory(this.getRootCategory()).ecomSeoData(this.getEcomSeoData());
        builder.name = this.internalGetName();
        builder.imageIds = this.internalGetImageIds();
        builder.isTopLevel = this.internalGetIsTopLevel();
        builder.channels = this.internalGetChannels();
        builder.availabilityPeriodIds = this.internalGetAvailabilityPeriodIds();
        builder.onlineVisibility = this.internalGetOnlineVisibility();
        builder.pathToRoot = this.internalGetPathToRoot();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> name;
        private OptionalNullable<List<String>> imageIds;
        private String categoryType;
        private CatalogObjectCategory parentCategory;
        private OptionalNullable<Boolean> isTopLevel;
        private OptionalNullable<List<String>> channels;
        private OptionalNullable<List<String>> availabilityPeriodIds;
        private OptionalNullable<Boolean> onlineVisibility;
        private String rootCategory;
        private CatalogEcomSeoData ecomSeoData;
        private OptionalNullable<List<CategoryPathToRootNode>> pathToRoot;

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder imageIds(List<String> imageIds) {
            this.imageIds = OptionalNullable.of(imageIds);
            return this;
        }

        public Builder unsetImageIds() {
            this.imageIds = null;
            return this;
        }

        public Builder categoryType(String categoryType) {
            this.categoryType = categoryType;
            return this;
        }

        public Builder parentCategory(CatalogObjectCategory parentCategory) {
            this.parentCategory = parentCategory;
            return this;
        }

        public Builder isTopLevel(Boolean isTopLevel) {
            this.isTopLevel = OptionalNullable.of((Object)isTopLevel);
            return this;
        }

        public Builder unsetIsTopLevel() {
            this.isTopLevel = null;
            return this;
        }

        public Builder channels(List<String> channels) {
            this.channels = OptionalNullable.of(channels);
            return this;
        }

        public Builder unsetChannels() {
            this.channels = null;
            return this;
        }

        public Builder availabilityPeriodIds(List<String> availabilityPeriodIds) {
            this.availabilityPeriodIds = OptionalNullable.of(availabilityPeriodIds);
            return this;
        }

        public Builder unsetAvailabilityPeriodIds() {
            this.availabilityPeriodIds = null;
            return this;
        }

        public Builder onlineVisibility(Boolean onlineVisibility) {
            this.onlineVisibility = OptionalNullable.of((Object)onlineVisibility);
            return this;
        }

        public Builder unsetOnlineVisibility() {
            this.onlineVisibility = null;
            return this;
        }

        public Builder rootCategory(String rootCategory) {
            this.rootCategory = rootCategory;
            return this;
        }

        public Builder ecomSeoData(CatalogEcomSeoData ecomSeoData) {
            this.ecomSeoData = ecomSeoData;
            return this;
        }

        public Builder pathToRoot(List<CategoryPathToRootNode> pathToRoot) {
            this.pathToRoot = OptionalNullable.of(pathToRoot);
            return this;
        }

        public Builder unsetPathToRoot() {
            this.pathToRoot = null;
            return this;
        }

        public CatalogCategory build() {
            return new CatalogCategory(this.name, this.imageIds, this.categoryType, this.parentCategory, this.isTopLevel, this.channels, this.availabilityPeriodIds, this.onlineVisibility, this.rootCategory, this.ecomSeoData, this.pathToRoot);
        }
    }
}

