/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogEcomSeoData {
    private final OptionalNullable<String> pageTitle;
    private final OptionalNullable<String> pageDescription;
    private final OptionalNullable<String> permalink;

    @JsonCreator
    public CatalogEcomSeoData(@JsonProperty(value="page_title") String pageTitle, @JsonProperty(value="page_description") String pageDescription, @JsonProperty(value="permalink") String permalink) {
        this.pageTitle = OptionalNullable.of((Object)pageTitle);
        this.pageDescription = OptionalNullable.of((Object)pageDescription);
        this.permalink = OptionalNullable.of((Object)permalink);
    }

    protected CatalogEcomSeoData(OptionalNullable<String> pageTitle, OptionalNullable<String> pageDescription, OptionalNullable<String> permalink) {
        this.pageTitle = pageTitle;
        this.pageDescription = pageDescription;
        this.permalink = permalink;
    }

    @JsonGetter(value="page_title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPageTitle() {
        return this.pageTitle;
    }

    @JsonIgnore
    public String getPageTitle() {
        return (String)OptionalNullable.getFrom(this.pageTitle);
    }

    @JsonGetter(value="page_description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPageDescription() {
        return this.pageDescription;
    }

    @JsonIgnore
    public String getPageDescription() {
        return (String)OptionalNullable.getFrom(this.pageDescription);
    }

    @JsonGetter(value="permalink")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPermalink() {
        return this.permalink;
    }

    @JsonIgnore
    public String getPermalink() {
        return (String)OptionalNullable.getFrom(this.permalink);
    }

    public int hashCode() {
        return Objects.hash(this.pageTitle, this.pageDescription, this.permalink);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogEcomSeoData)) {
            return false;
        }
        CatalogEcomSeoData other = (CatalogEcomSeoData)obj;
        return Objects.equals(this.pageTitle, other.pageTitle) && Objects.equals(this.pageDescription, other.pageDescription) && Objects.equals(this.permalink, other.permalink);
    }

    public String toString() {
        return "CatalogEcomSeoData [pageTitle=" + this.pageTitle + ", pageDescription=" + this.pageDescription + ", permalink=" + this.permalink + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.pageTitle = this.internalGetPageTitle();
        builder.pageDescription = this.internalGetPageDescription();
        builder.permalink = this.internalGetPermalink();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> pageTitle;
        private OptionalNullable<String> pageDescription;
        private OptionalNullable<String> permalink;

        public Builder pageTitle(String pageTitle) {
            this.pageTitle = OptionalNullable.of((Object)pageTitle);
            return this;
        }

        public Builder unsetPageTitle() {
            this.pageTitle = null;
            return this;
        }

        public Builder pageDescription(String pageDescription) {
            this.pageDescription = OptionalNullable.of((Object)pageDescription);
            return this;
        }

        public Builder unsetPageDescription() {
            this.pageDescription = null;
            return this;
        }

        public Builder permalink(String permalink) {
            this.permalink = OptionalNullable.of((Object)permalink);
            return this;
        }

        public Builder unsetPermalink() {
            this.permalink = null;
            return this;
        }

        public CatalogEcomSeoData build() {
            return new CatalogEcomSeoData(this.pageTitle, this.pageDescription, this.permalink);
        }
    }
}

