/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CatalogItemFoodAndBeverageDetailsIngredient {
    private final String type;
    private final String standardName;
    private final OptionalNullable<String> customName;

    @JsonCreator
    public CatalogItemFoodAndBeverageDetailsIngredient(@JsonProperty(value="type") String type, @JsonProperty(value="standard_name") String standardName, @JsonProperty(value="custom_name") String customName) {
        this.type = type;
        this.standardName = standardName;
        this.customName = OptionalNullable.of((Object)customName);
    }

    protected CatalogItemFoodAndBeverageDetailsIngredient(String type, String standardName, OptionalNullable<String> customName) {
        this.type = type;
        this.standardName = standardName;
        this.customName = customName;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="standard_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStandardName() {
        return this.standardName;
    }

    @JsonGetter(value="custom_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomName() {
        return this.customName;
    }

    @JsonIgnore
    public String getCustomName() {
        return (String)OptionalNullable.getFrom(this.customName);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.standardName, this.customName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemFoodAndBeverageDetailsIngredient)) {
            return false;
        }
        CatalogItemFoodAndBeverageDetailsIngredient other = (CatalogItemFoodAndBeverageDetailsIngredient)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.standardName, other.standardName) && Objects.equals(this.customName, other.customName);
    }

    public String toString() {
        return "CatalogItemFoodAndBeverageDetailsIngredient [type=" + this.type + ", standardName=" + this.standardName + ", customName=" + this.customName + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).standardName(this.getStandardName());
        builder.customName = this.internalGetCustomName();
        return builder;
    }

    public static class Builder {
        private String type;
        private String standardName;
        private OptionalNullable<String> customName;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder standardName(String standardName) {
            this.standardName = standardName;
            return this;
        }

        public Builder customName(String customName) {
            this.customName = OptionalNullable.of((Object)customName);
            return this;
        }

        public Builder unsetCustomName() {
            this.customName = null;
            return this;
        }

        public CatalogItemFoodAndBeverageDetailsIngredient build() {
            return new CatalogItemFoodAndBeverageDetailsIngredient(this.type, this.standardName, this.customName);
        }
    }
}

