/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogModifierOverride;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CatalogItemModifierListInfo {
    private final String modifierListId;
    private final OptionalNullable<List<CatalogModifierOverride>> modifierOverrides;
    private final OptionalNullable<Integer> minSelectedModifiers;
    private final OptionalNullable<Integer> maxSelectedModifiers;
    private final OptionalNullable<Boolean> enabled;

    @JsonCreator
    public CatalogItemModifierListInfo(@JsonProperty(value="modifier_list_id") String modifierListId, @JsonProperty(value="modifier_overrides") List<CatalogModifierOverride> modifierOverrides, @JsonProperty(value="min_selected_modifiers") Integer minSelectedModifiers, @JsonProperty(value="max_selected_modifiers") Integer maxSelectedModifiers, @JsonProperty(value="enabled") Boolean enabled) {
        this.modifierListId = modifierListId;
        this.modifierOverrides = OptionalNullable.of(modifierOverrides);
        this.minSelectedModifiers = OptionalNullable.of((Object)minSelectedModifiers);
        this.maxSelectedModifiers = OptionalNullable.of((Object)maxSelectedModifiers);
        this.enabled = OptionalNullable.of((Object)enabled);
    }

    protected CatalogItemModifierListInfo(String modifierListId, OptionalNullable<List<CatalogModifierOverride>> modifierOverrides, OptionalNullable<Integer> minSelectedModifiers, OptionalNullable<Integer> maxSelectedModifiers, OptionalNullable<Boolean> enabled) {
        this.modifierListId = modifierListId;
        this.modifierOverrides = modifierOverrides;
        this.minSelectedModifiers = minSelectedModifiers;
        this.maxSelectedModifiers = maxSelectedModifiers;
        this.enabled = enabled;
    }

    @JsonGetter(value="modifier_list_id")
    public String getModifierListId() {
        return this.modifierListId;
    }

    @JsonGetter(value="modifier_overrides")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CatalogModifierOverride>> internalGetModifierOverrides() {
        return this.modifierOverrides;
    }

    @JsonIgnore
    public List<CatalogModifierOverride> getModifierOverrides() {
        return (List)OptionalNullable.getFrom(this.modifierOverrides);
    }

    @JsonGetter(value="min_selected_modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetMinSelectedModifiers() {
        return this.minSelectedModifiers;
    }

    @JsonIgnore
    public Integer getMinSelectedModifiers() {
        return (Integer)OptionalNullable.getFrom(this.minSelectedModifiers);
    }

    @JsonGetter(value="max_selected_modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetMaxSelectedModifiers() {
        return this.maxSelectedModifiers;
    }

    @JsonIgnore
    public Integer getMaxSelectedModifiers() {
        return (Integer)OptionalNullable.getFrom(this.maxSelectedModifiers);
    }

    @JsonGetter(value="enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetEnabled() {
        return this.enabled;
    }

    @JsonIgnore
    public Boolean getEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogItemModifierListInfo)) {
            return false;
        }
        CatalogItemModifierListInfo other = (CatalogItemModifierListInfo)obj;
        return Objects.equals(this.modifierListId, other.modifierListId) && Objects.equals(this.modifierOverrides, other.modifierOverrides) && Objects.equals(this.minSelectedModifiers, other.minSelectedModifiers) && Objects.equals(this.maxSelectedModifiers, other.maxSelectedModifiers) && Objects.equals(this.enabled, other.enabled);
    }

    public String toString() {
        return "CatalogItemModifierListInfo [modifierListId=" + this.modifierListId + ", modifierOverrides=" + this.modifierOverrides + ", minSelectedModifiers=" + this.minSelectedModifiers + ", maxSelectedModifiers=" + this.maxSelectedModifiers + ", enabled=" + this.enabled + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.modifierListId);
        builder.modifierOverrides = this.internalGetModifierOverrides();
        builder.minSelectedModifiers = this.internalGetMinSelectedModifiers();
        builder.maxSelectedModifiers = this.internalGetMaxSelectedModifiers();
        builder.enabled = this.internalGetEnabled();
        return builder;
    }

    public static class Builder {
        private String modifierListId;
        private OptionalNullable<List<CatalogModifierOverride>> modifierOverrides;
        private OptionalNullable<Integer> minSelectedModifiers;
        private OptionalNullable<Integer> maxSelectedModifiers;
        private OptionalNullable<Boolean> enabled;

        public Builder(String modifierListId) {
            this.modifierListId = modifierListId;
        }

        public Builder modifierListId(String modifierListId) {
            this.modifierListId = modifierListId;
            return this;
        }

        public Builder modifierOverrides(List<CatalogModifierOverride> modifierOverrides) {
            this.modifierOverrides = OptionalNullable.of(modifierOverrides);
            return this;
        }

        public Builder unsetModifierOverrides() {
            this.modifierOverrides = null;
            return this;
        }

        public Builder minSelectedModifiers(Integer minSelectedModifiers) {
            this.minSelectedModifiers = OptionalNullable.of((Object)minSelectedModifiers);
            return this;
        }

        public Builder unsetMinSelectedModifiers() {
            this.minSelectedModifiers = null;
            return this;
        }

        public Builder maxSelectedModifiers(Integer maxSelectedModifiers) {
            this.maxSelectedModifiers = OptionalNullable.of((Object)maxSelectedModifiers);
            return this;
        }

        public Builder unsetMaxSelectedModifiers() {
            this.maxSelectedModifiers = null;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = OptionalNullable.of((Object)enabled);
            return this;
        }

        public Builder unsetEnabled() {
            this.enabled = null;
            return this;
        }

        public CatalogItemModifierListInfo build() {
            return new CatalogItemModifierListInfo(this.modifierListId, this.modifierOverrides, this.minSelectedModifiers, this.maxSelectedModifiers, this.enabled);
        }
    }
}

